/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.commands.vanilla;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.azureaaron.mod.Colour;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.events.PlaySoundEvent;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Formatters;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2767;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7157;

public class WardenWarningLevelCommand {
    private static final Supplier<class_2561> DISCLAIMER = () -> class_2561.method_43470((String)"It isn't possible to find out the\nexact player who triggered the shrieker.\n\nThis may not be 100% accurate.").method_27694(style -> style.method_36139(Constants.PROFILE.get().infoColour.getAsInt()));
    private static final Set<class_3414> WARNING_SOUNDS = Set.of(class_3417.field_38072, class_3417.field_38073, class_3417.field_38074, class_3417.field_38071);
    private static int warningLevel = 0;
    private static long lastShriekTime = 0L;

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(WardenWarningLevelCommand::register);
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> WardenWarningLevelCommand.reset());
        PlaySoundEvent.EVENT.register(WardenWarningLevelCommand::onPlaySound);
    }

    private static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"wardenwarninglevel").executes(context -> WardenWarningLevelCommand.printWardenWarningLevel((FabricClientCommandSource)context.getSource())));
    }

    private static int printWardenWarningLevel(FabricClientCommandSource source) {
        Colour.ColourProfiles colourProfile = Constants.PROFILE.get();
        int warningLevel = WardenWarningLevelCommand.relativeWarningLevel();
        int warningsLeft = warningLevel == 0 ? 3 : 3 - warningLevel;
        String lastTriggered = lastShriekTime == 0L ? "Unknown" : Formatters.toRelativeTime(System.currentTimeMillis() - lastShriekTime).greatest();
        String spacing = "                              ";
        RenderHelper.runOnRenderThread(() -> {
            source.sendFeedback((class_2561)class_2561.method_43470((String)spacing).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Warning Level \u00bb " + warningLevel)).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt()).method_10949((class_2568)new class_2568.class_10613(DISCLAIMER.get()))));
            source.sendFeedback((class_2561)class_2561.method_43470((String)""));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Warnings Left \u00bb " + warningsLeft)).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("Last Triggered Shrieker \u00bb " + lastTriggered)).method_27694(style -> style.method_36139(colourProfile.infoColour.getAsInt())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)spacing).method_27694(style -> style.method_36139(colourProfile.primaryColour.getAsInt()).method_36140(Boolean.valueOf(true))));
        });
        return 1;
    }

    private static void reset() {
        if (!Cache.lastServerAddress.equals(Cache.currentServerAddress)) {
            warningLevel = 0;
            lastShriekTime = 0L;
        }
    }

    private static void onPlaySound(class_2767 packet) {
        if (packet.method_11888() == class_3419.field_15251 && WARNING_SOUNDS.contains(packet.method_11894().comp_349())) {
            lastShriekTime = System.currentTimeMillis();
            class_3414 class_34142 = (class_3414)packet.method_11894().comp_349();
            Objects.requireNonNull(class_34142);
            class_3414 class_34143 = class_34142;
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_3414.class, class_3414.class, class_3414.class, class_3414.class}, (Object)class_34143, n)) {
                    case 0: {
                        class_3414 s = class_34143;
                        if (!s.equals((Object)class_3417.field_38072)) {
                            n = 1;
                            continue block6;
                        }
                        warningLevel = 1;
                        break block6;
                    }
                    case 1: {
                        class_3414 s = class_34143;
                        if (!s.equals((Object)class_3417.field_38073)) {
                            n = 2;
                            continue block6;
                        }
                        warningLevel = 2;
                        break block6;
                    }
                    case 2: {
                        class_3414 s = class_34143;
                        if (!s.equals((Object)class_3417.field_38074)) {
                            n = 3;
                            continue block6;
                        }
                        warningLevel = 3;
                        break block6;
                    }
                    case 3: {
                        class_3414 s = class_34143;
                        if (!s.equals((Object)class_3417.field_38071)) {
                            n = 4;
                            continue block6;
                        }
                        warningLevel = 4;
                        break block6;
                    }
                }
                break;
            }
        }
    }

    private static int relativeWarningLevel() {
        int tenMinuteIncrementsPassed = (int)((System.currentTimeMillis() - lastShriekTime) / 600000L);
        return lastShriekTime == 0L ? 0 : Math.max(warningLevel - tenMinuteIncrementsPassed, 0);
    }
}

