/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.config.datafixer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.azureaaron.mod.Main;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.datafixer.ConfigFixV1;
import net.azureaaron.mod.config.datafixer.ConfigFixV2;
import net.azureaaron.mod.config.datafixer.ConfigSchema;
import net.azureaaron.mod.utils.JsonHelper;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;

public class ConfigDataFixer {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final DSL.TypeReference CONFIG_TYPE = () -> "aaron-mod:config";

    public static void apply() {
        try {
            JsonObject oldConfig;
            int version;
            if (Files.exists(AaronModConfigManager.PATH, new LinkOption[0]) && (version = JsonHelper.getInt(oldConfig = JsonParser.parseString((String)Files.readString(AaronModConfigManager.PATH)).getAsJsonObject(), "version").orElse(1)) != 3) {
                long start = System.currentTimeMillis();
                DataFixer fixer = ConfigDataFixer.build();
                Dynamic fixed = fixer.update(CONFIG_TYPE, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)oldConfig), version, 3);
                JsonObject newConfig = ((JsonElement)fixed.getValue()).getAsJsonObject();
                LOGGER.info("[Aaron's Mod Config Data Fixer] Successfully applied data fixers in {} ms!", (Object)(System.currentTimeMillis() - start));
                if (!ConfigDataFixer.saveConfig(AaronModConfigManager.PATH, newConfig)) {
                    Path fallback = FabricLoader.getInstance().getConfigDir().resolve("aaron-mod.json.old");
                    LOGGER.error(LogUtils.FATAL_MARKER, "[Aaron's Mod Config Data Fixer] Failed to write new config file! Saving old one at: {}", (Object)fallback);
                    ConfigDataFixer.saveConfig(fallback, oldConfig);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Config Data Fixer] Failed to apply config data fixers!", (Throwable)e);
        }
    }

    private static boolean saveConfig(Path path, JsonObject config) {
        try {
            Files.writeString(path, (CharSequence)Main.GSON.toJson((JsonElement)config), new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Config Data Fixer] Failed to write config to {}.", (Throwable)e);
            return false;
        }
    }

    @VisibleForTesting
    protected static DataFixer build() {
        DataFixerBuilder builder = new DataFixerBuilder(3);
        builder.addSchema(1, ConfigSchema::new);
        Schema schema2 = builder.addSchema(2, Schema::new);
        builder.addFixer((DataFix)new ConfigFixV1(schema2, true));
        Schema schema3 = builder.addSchema(3, Schema::new);
        builder.addFixer((DataFix)new ConfigFixV2(schema3, true));
        return builder.build().fixer();
    }
}

