/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.features;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.List;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.configs.RefinementsConfig;
import net.azureaaron.mod.mixins.accessors.ChatAccessor;
import net.azureaaron.mod.utils.ItemUtils;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_8824;
import org.apache.commons.lang3.StringUtils;

public class CopyChatMessages {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final class_2561 SUCCESS_TITLE = class_2561.method_43470((String)"Success!");
    private static final class_2561 SUCCESS_DESCRIPTION = class_2561.method_43470((String)"The message was copied to your clipboard!");
    private static final class_2561 NOT_FOUND_TITLE = class_2561.method_43470((String)"Not Found!");
    private static final class_2561 NOT_FOUND_DESCRIPTION = class_2561.method_43470((String)"No message was hovered over!");

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((_client, screen, scaledWidth, scaledHeight) -> {
            if (screen instanceof class_408) {
                class_408 chat = (class_408)screen;
                ScreenMouseEvents.afterMouseClick((class_437)chat).register(CopyChatMessages::onMouseInput);
            }
        });
    }

    private static boolean onMouseInput(class_437 screen, class_11909 click, boolean consumed) {
        int configuredButton = AaronModConfigManager.get().refinements.chat.copyChatMouseButton == RefinementsConfig.MouseButton.MIDDLE ? 2 : 0;
        ChatAccessor chatAccessor = (ChatAccessor)CopyChatMessages.CLIENT.field_1705.method_1743();
        if (click.method_74245() == configuredButton && AaronModConfigManager.get().refinements.chat.copyChatMessages) {
            double chatLineX = chatAccessor.invokeToChatLineX(click.comp_4798());
            double chatLineY = chatAccessor.invokeToChatLineY(click.comp_4799());
            switch (AaronModConfigManager.get().refinements.chat.copyChatMode) {
                case SINGLE_LINE: {
                    int messageLineIndex = chatAccessor.invokeGetMessageLineIndex(chatLineX, chatLineY);
                    List<class_303.class_7590> visibleMessages = chatAccessor.getVisibleMessages();
                    if (messageLineIndex >= 0 && messageLineIndex < visibleMessages.size()) {
                        class_5481 orderedText = visibleMessages.get(messageLineIndex).comp_896();
                        StringBuilder message = new StringBuilder();
                        orderedText.accept((index, style, codePoint) -> {
                            message.appendCodePoint(codePoint);
                            return true;
                        });
                        CopyChatMessages.CLIENT.field_1774.method_1455(message.toString());
                        CopyChatMessages.sendToast(true);
                        return true;
                    }
                    CopyChatMessages.sendToast(false);
                    break;
                }
                case ENTIRE_MESSAGE: {
                    int messageIndex = CopyChatMessages.getMessageIndex(chatLineX, chatLineY);
                    List<class_303> messages = chatAccessor.getMessages();
                    if (messageIndex > -1 && messageIndex < messages.size()) {
                        class_2561 message = messages.get(messageIndex).comp_893();
                        String text2Copy = !click.method_74238() ? class_124.method_539((String)message.getString()) : (String)class_8824.field_46597.encodeStart((DynamicOps)ItemUtils.getRegistryLookup().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)message).mapOrElse(JsonElement::toString, e -> "Error while encoding JSON text: " + e.message());
                        CopyChatMessages.CLIENT.field_1774.method_1455(text2Copy);
                        CopyChatMessages.sendToast(true);
                        return true;
                    }
                    CopyChatMessages.sendToast(false);
                }
            }
        }
        return false;
    }

    private static void sendToast(boolean success) {
        class_374 toastManager = CLIENT.method_1566();
        if (success) {
            class_370.method_27024((class_374)toastManager, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)SUCCESS_TITLE, (class_2561)SUCCESS_DESCRIPTION);
        } else {
            class_370.method_27024((class_374)toastManager, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)NOT_FOUND_TITLE, (class_2561)NOT_FOUND_DESCRIPTION);
        }
    }

    private static int getMessageIndex(double chatLineX, double chatLineY) {
        int i;
        ChatAccessor chatAccessor = (ChatAccessor)CopyChatMessages.CLIENT.field_1705.method_1743();
        int lineIndex = chatAccessor.invokeGetMessageLineIndex(chatLineX, chatLineY);
        if (lineIndex == -1) {
            return -1;
        }
        List<class_303> messages = chatAccessor.getMessages();
        List<class_303.class_7590> visibleMessages = chatAccessor.getVisibleMessages();
        int upperbound = 0;
        int lowerbound = chatAccessor.invokeGetMessageEndLineIndex(chatLineX, chatLineY);
        for (int i2 = lowerbound + 1; i2 < visibleMessages.size(); ++i2) {
            if (visibleMessages.get(i2).comp_898()) {
                upperbound = i2 - 1;
                break;
            }
            if (i2 != visibleMessages.size() - 1) continue;
            upperbound = i2;
        }
        StringBuilder hoveredMessage = new StringBuilder();
        for (i = upperbound; i >= lowerbound; --i) {
            class_303.class_7590 currentEntry = visibleMessages.get(i);
            currentEntry.comp_896().accept((index, style, codePoint) -> {
                if (!Character.isWhitespace(codePoint)) {
                    hoveredMessage.appendCodePoint(codePoint);
                }
                return true;
            });
        }
        for (i = 0; i < messages.size(); ++i) {
            class_303 currentMessage = messages.get(i);
            String messageContent = StringUtils.deleteWhitespace((String)class_124.method_539((String)currentMessage.comp_893().getString()));
            if (!messageContent.equals(hoveredMessage.toString())) continue;
            return i;
        }
        return -1;
    }
}

