/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.features;

import java.awt.Color;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.azureaaron.mod.Main;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.events.WorldRenderExtractionCallback;
import net.azureaaron.mod.mixins.accessors.ClientEntityManagerAccessor;
import net.azureaaron.mod.mixins.accessors.ClientWorldAccessor;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.render.primitive.PrimitiveCollector;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1531;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5570;
import net.minecraft.class_638;

public class DragonHealth {
    private static final Pattern DRAGON_HP = Pattern.compile("\ufd3e (?:.+ )?Withered Dragon (?:\\u16E4 )?(?<health>[\\dkKMB.]+)\\/(?<max>[\\dkKMB.]+)\\u2764 \ufd3f");

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(DragonHealth::extractRendering);
    }

    private static void extractRendering(PrimitiveCollector collector) {
        try {
            if (Cache.inM7Phase5 && AaronModConfigManager.get().skyblock.m7.dragonHealthDisplay) {
                class_310 client = class_310.method_1551();
                class_638 world = client.field_1687;
                if (world != null) {
                    block2: for (class_1297 entity : world.method_18112()) {
                        if (!(entity instanceof class_1510)) continue;
                        class_1510 dragon = (class_1510)entity;
                        class_5570 entityIndex = ((ClientEntityManagerAccessor)((ClientWorldAccessor)world).getEntityManager()).getIndex();
                        for (class_1297 indexedEntity : entityIndex.method_31751()) {
                            String name;
                            Matcher matcher;
                            class_1531 armourStand;
                            if (!(indexedEntity instanceof class_1531) || !(armourStand = (class_1531)indexedEntity).method_5829().method_994(dragon.method_5829()) || !armourStand.method_16914() || !(matcher = DRAGON_HP.matcher(name = armourStand.method_5477().getString())).matches()) continue;
                            String healthSegment = matcher.group("health");
                            String maxHealthSegment = matcher.group("max");
                            float health = (float)DragonHealth.getHealth(healthSegment);
                            float maxHealth = (float)DragonHealth.getHealth(maxHealthSegment);
                            float hp = health / maxHealth * 100.0f;
                            int colour = DragonHealth.getHealthColour(hp);
                            class_243 pos = dragon.method_30950(client.method_61966().method_60637(false)).method_1023(0.0, 1.0, 0.0);
                            collector.submitText((class_2561)class_2561.method_43470((String)healthSegment).method_27694(style -> style.method_36139(colour)), pos, 8.0f, true);
                            continue block2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Main.LOGGER.error("[Aaron's Mod] Failed to render a dragon's health! {}", (Throwable)e);
        }
    }

    private static double getHealth(String health) {
        try {
            double multiplier = 1.0;
            health = ((String)health).toUpperCase(Locale.CANADA);
            if (((String)health).endsWith("K")) {
                multiplier = 1000.0;
                health = ((String)health).substring(0, ((String)health).length() - 1);
            } else if (((String)health).endsWith("M")) {
                multiplier = 1000000.0;
                health = ((String)health).substring(0, ((String)health).length() - 1);
            } else if (((String)health).endsWith("B")) {
                multiplier = 1.0E9;
                health = ((String)health).substring(0, ((String)health).length() - 1);
            }
            if (!((String)health).contains(".")) {
                health = (String)health + ".0";
            }
            return Double.parseDouble((String)health) * multiplier;
        }
        catch (Exception e) {
            Main.LOGGER.error("[Aaron's Mod] Failed to parse dragon health! Input: {}", health, (Object)e);
            return 0.0;
        }
    }

    private static int getHealthColour(float percentage) {
        return Color.HSBtoRGB(percentage / 300.0f, 0.9f, 0.9f);
    }
}

