/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.features;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.events.ParticleSpawnEvent;
import net.azureaaron.mod.events.ServerTickCallback;
import net.azureaaron.mod.events.WorldRenderExtractionCallback;
import net.azureaaron.mod.features.DragonNotifications;
import net.azureaaron.mod.features.Dragons;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.render.primitive.PrimitiveCollector;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_5250;

public class DragonTimers {
    private static final class_243 POWER_TEXT_LOCATION = new class_243(26.0, 16.0, 59.0);
    private static final class_243 FLAME_TEXT_LOCATION = new class_243(86.0, 16.0, 56.0);
    private static final class_243 APEX_TEXT_LOCATION = new class_243(26.0, 16.0, 94.0);
    private static final class_243 ICE_TEXT_LOCATION = new class_243(85.0, 16.0, 94.0);
    private static final class_243 SOUL_TEXT_LOCATION = new class_243(56.0, 16.0, 126.0);
    private static final Reference2ObjectOpenHashMap<Dragons, class_243> DRAGON_SPAWN_TEXT_LOCATIONS = (Reference2ObjectOpenHashMap)class_156.method_654((Object)new Reference2ObjectOpenHashMap(), map -> {
        map.put((Object)Dragons.POWER, (Object)POWER_TEXT_LOCATION);
        map.put((Object)Dragons.FLAME, (Object)FLAME_TEXT_LOCATION);
        map.put((Object)Dragons.APEX, (Object)APEX_TEXT_LOCATION);
        map.put((Object)Dragons.ICE, (Object)ICE_TEXT_LOCATION);
        map.put((Object)Dragons.SOUL, (Object)SOUL_TEXT_LOCATION);
    });

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(DragonTimers::extractRendering);
        ParticleSpawnEvent.EVENT.register(DragonTimers::onParticle);
        ServerTickCallback.EVENT.register(DragonTimers::onServerTick);
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (Functions.isOnHypixel() && AaronModConfigManager.get().skyblock.m7.dragonSpawnTimers && Cache.inM7Phase5) {
            for (Dragons dragon : Dragons.VALUES) {
                if (dragon.spawnTime <= 0) continue;
                int timeUntilSpawn = (int)((long)dragon.spawnTime * 50L);
                class_5250 spawnText = class_2561.method_43470((String)(timeUntilSpawn + " ms"));
                collector.submitText((class_2561)spawnText, (class_243)DRAGON_SPAWN_TEXT_LOCATIONS.get((Object)dragon), 8.0f, true);
            }
        }
    }

    private static void onParticle(class_2675 packet) {
        if (Functions.isOnHypixel() && Cache.inM7Phase5 && packet.method_11551().method_10295().equals(class_2398.field_11215)) {
            for (Dragons dragon : Dragons.VALUES) {
                int xShrinkFactor = dragon.pos1.method_10263() == 41 ? 11 : 0;
                int zShrinkFactor = dragon.pos1.method_10260() == 112 ? 0 : 11;
                class_238 box = class_238.method_54784((class_2338)dragon.pos1.method_10069(0, 14, 0), (class_2338)dragon.pos2).method_35580((double)xShrinkFactor, 0.0, (double)zShrinkFactor);
                if (!box.method_1008(packet.method_11544(), packet.method_11547(), packet.method_11546()) || dragon.spawnTime > 0) continue;
                dragon.spawnTime = 100;
                DragonNotifications.notifySpawn(dragon);
            }
        }
    }

    private static void onServerTick() {
        if (Functions.isOnHypixel() && Cache.inM7Phase5) {
            for (Dragons dragon : Dragons.VALUES) {
                if (dragon.spawnTime <= 0) continue;
                --dragon.spawnTime;
            }
        }
    }
}

