/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.features;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.events.ReceiveChatMessageEvent;
import net.azureaaron.mod.utils.Http;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;

public class ImagePreview {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Pattern IMAGE_URL_PATTERN = Pattern.compile("https:\\/\\/.*\\.(?:png|jpg|jpeg)\\.?(?:\\?.+)?", 2);
    private static final ImmutableSet<String> EXPECTED_CONTENT_TYPES = ImmutableSet.of((Object)"image/png", (Object)"image/jpeg");
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final Map<String, CachedImage> IMAGE_CACHE = new ConcurrentHashMap<String, CachedImage>();

    @Init
    public static void init() {
        ReceiveChatMessageEvent.EVENT.register(ImagePreview::inspectMessageForImageLinks);
        ScreenEvents.AFTER_INIT.register((client, screen, _scaledWidth, _scaledHeight) -> {
            if (screen instanceof class_408 && AaronModConfigManager.get().uiAndVisuals.imagePreview.enableImagePreview) {
                ScreenEvents.afterRender((class_437)screen).register((screen1, context, mouseX, mouseY, _delta) -> ImagePreview.afterScreenRendered(client, screen1, context, mouseX, mouseY));
            }
        });
    }

    private static void inspectMessageForImageLinks(class_2561 text, boolean overlay, boolean cancelled) {
        if (AaronModConfigManager.get().uiAndVisuals.imagePreview.enableImagePreview && !overlay && !cancelled) {
            ObjectOpenHashSet foundImages = new ObjectOpenHashSet();
            text.method_27658((style, stringified) -> {
                String url;
                URI uri;
                class_2558 clickEvent = style.method_10970();
                if (!(clickEvent instanceof class_2558.class_10608)) return Optional.empty();
                class_2558.class_10608 $b$0 = (class_2558.class_10608)clickEvent;
                try {
                    URI patt1$temp;
                    uri = patt1$temp = $b$0.comp_3505();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (uri == null || !IMAGE_URL_PATTERN.matcher(url = ImagePreview.fixupLink(uri.toString())).matches()) return Optional.empty();
                foundImages.add((Object)url);
                return Optional.empty();
            }, class_2583.field_24360);
            for (String imageUrl : foundImages) {
                if (IMAGE_CACHE.containsKey(imageUrl)) continue;
                ImagePreview.cacheImage(imageUrl);
            }
        }
    }

    private static void cacheImage(String url) {
        CompletableFuture.runAsync(() -> {
            try {
                URI uri = URI.create(url);
                if (ImagePreview.isAllowedImageHost(uri.getHost())) {
                    IMAGE_CACHE.put(url, CachedImage.EMPTY);
                    class_310 client = class_310.method_1551();
                    InputStream inputStream = Http.sendGenericH2Request(uri, EXPECTED_CONTENT_TYPES);
                    class_1011 image = class_1011.method_4309((InputStream)inputStream);
                    class_2960 id = class_2960.method_60655((String)"aaron-mod", (String)("image_preview/" + COUNTER.getAndIncrement()));
                    client.method_63588(() -> {
                        client.method_1531().method_4616(id, (class_1044)new class_1043(() -> ((class_2960)id).toString(), image));
                        IMAGE_CACHE.put(url, new CachedImage(System.currentTimeMillis(), id, image.method_4307(), image.method_4323()));
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("[Aaron's Mod Image Preivew] Failed to cache image! URL: {}", (Object)url, (Object)e);
            }
        });
    }

    private static void afterScreenRendered(class_310 client, class_437 screen, class_332 context, int mouseX, int mouseY) {
        class_2558 clickEvent;
        if (!AaronModConfigManager.get().uiAndVisuals.imagePreview.enableImagePreview) {
            return;
        }
        class_2583 style = client.field_1705.method_1743().method_1816((double)mouseX, (double)mouseY);
        if (style != null && style.method_10970() != null && (clickEvent = style.method_10970()) instanceof class_2558.class_10608) {
            CachedImage image;
            URI uri;
            class_2558.class_10608 class_106082 = (class_2558.class_10608)clickEvent;
            try {
                URI uRI;
                uri = uRI = class_106082.comp_3505();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (uri != null && (image = (CachedImage)IMAGE_CACHE.getOrDefault(ImagePreview.fixupLink(uri.toString()), null)) != null && image != CachedImage.EMPTY) {
                Matrix3x2fStack matrices = context.method_51448();
                int width = image.width();
                int height = image.height();
                float scale = Math.min(1.0f, Math.min(ImagePreview.getPrevWidthDiv() / (float)width, ImagePreview.getPrevHeightDiv() / (float)height));
                matrices.pushMatrix();
                matrices.scale(scale, scale);
                context.method_25290(class_10799.field_56883, image.texture(), 0, 0, 0.0f, 0.0f, width, height, width, height);
                matrices.popMatrix();
            }
        }
    }

    public static void clearCache(class_310 client) {
        for (Map.Entry<String, CachedImage> entry : IMAGE_CACHE.entrySet()) {
            client.method_1531().method_4615(entry.getValue().texture());
        }
        IMAGE_CACHE.clear();
    }

    private static boolean isAllowedImageHost(String host) {
        return host.equals("cdn.discordapp.com") || host.equals("media.discordapp.net") || host.equals("i.imgur.com");
    }

    private static String fixupLink(String url) {
        if (url.startsWith("https://imgur.com")) {
            return url.replace("https://imgur.com", "https://i.imgur.com");
        }
        return url;
    }

    private static float getPrevWidthDiv() {
        return 256.0f * AaronModConfigManager.get().uiAndVisuals.imagePreview.scale;
    }

    private static float getPrevHeightDiv() {
        return 144.0f * AaronModConfigManager.get().uiAndVisuals.imagePreview.scale;
    }

    private record CachedImage(long creationTime, class_2960 texture, int width, int height) {
        private static final CachedImage EMPTY = new CachedImage(0L, null, 0, 0);
    }
}

