/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.screens.itemmodel;

import it.unimi.dsi.fastutil.floats.FloatConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.config.configs.ItemModelConfig;
import net.azureaaron.mod.utils.render.GuiHelper;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8029;
import net.minecraft.class_8030;
import net.minecraft.class_9848;

public class CustomizeItemModelScreen
extends class_437 {
    private static final int TEXT_FIELD_WIDTH = 50;
    private static final int TEXT_FIELD_HEIGHT = 20;
    private static final Predicate<String> FLOAT_INPUT_REGEX = Pattern.compile("[-+]?[0-9]*\\.?[0-9]*").asMatchPredicate();
    private static final int BUTTON_WIDTH = 50;
    private static final int OUTLINE_COLOUR = class_9848.method_61324((int)191, (int)0, (int)0, (int)0);
    private static final int INNER_OUTLINE_COLOUR = class_9848.method_61324((int)51, (int)255, (int)255, (int)255);
    private final class_437 parent;
    public final class_1268 hand;
    public final class_1799 previewItem;
    private final ItemModelConfig.AbstractHand config;
    private final ItemModelConfig.AbstractHand backup;
    private boolean hasChanges;

    protected CustomizeItemModelScreen(class_437 parent, class_1268 hand, class_1799 previewItem) {
        super((class_2561)class_2561.method_43470((String)(hand == class_1268.field_5808 ? "Customize Main Hand" : "Customize Off Hand")));
        this.parent = parent;
        this.hand = hand;
        this.previewItem = previewItem;
        this.config = switch (this.hand) {
            default -> throw new MatchException(null, null);
            case class_1268.field_5808 -> AaronModConfigManager.get().itemModel.mainHand;
            case class_1268.field_5810 -> AaronModConfigManager.get().itemModel.offHand;
        };
        this.backup = new ItemModelConfig.AbstractHand().copyFrom(this.config);
    }

    protected void method_25426() {
        class_8030 dimensions = this.getEffectiveDimensions(this.field_22789, this.field_22790);
        class_7845 gridWidget = new class_7845();
        gridWidget.method_48637(8);
        class_7845.class_7939 adder = gridWidget.method_47610(3);
        adder.method_47613((class_8021)new class_7842(this.field_22785, this.field_22793), 3);
        this.addEnableCustomizationsCheckbox(adder);
        this.addTranslationButtons(adder);
        this.addScaleButtons(adder);
        this.addRotationButtons(adder);
        this.addFinalButtons(adder);
        gridWidget.method_48222();
        class_7843.method_49617((class_8021)gridWidget, (class_8030)dimensions, (float)0.15f, (float)0.35f);
        gridWidget.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
    }

    private void addEnableCustomizationsCheckbox(class_7845.class_7939 adder) {
        class_4286 enableCustomizations = class_4286.method_54787((class_2561)class_2561.method_30163((String)"Enable Customizations"), (class_327)this.field_22793).method_54794(this.config.enabled).method_54791((checkbox, checked) -> {
            this.config.enabled = checked;
            this.hasChanges = true;
        }).method_54788();
        adder.method_47613((class_8021)enableCustomizations, 3);
    }

    private void addTranslationButtons(class_7845.class_7939 adder) {
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Translations"), this.field_22793), 3);
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"X"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Y"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Z"), this.field_22793));
        class_342 xTranslationField = this.newFloatField(class_2561.method_30163((String)"X Translation"), () -> Float.valueOf(this.config.x), newValue -> {
            this.config.x = newValue;
        });
        class_342 yTranslationField = this.newFloatField(class_2561.method_30163((String)"Y Translation"), () -> Float.valueOf(this.config.y), newValue -> {
            this.config.y = newValue;
        });
        class_342 zTranslationField = this.newFloatField(class_2561.method_30163((String)"Z Translation"), () -> Float.valueOf(this.config.z), newValue -> {
            this.config.z = newValue;
        });
        adder.method_47612((class_8021)xTranslationField);
        adder.method_47612((class_8021)yTranslationField);
        adder.method_47612((class_8021)zTranslationField);
    }

    private void addScaleButtons(class_7845.class_7939 adder) {
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Scaling"), this.field_22793), 3);
        class_342 scalingField = this.newFloatField(class_2561.method_30163((String)"Scaling"), () -> Float.valueOf(this.config.scale), newValue -> {
            this.config.scale = newValue;
        });
        adder.method_47613((class_8021)scalingField, 3);
    }

    private void addRotationButtons(class_7845.class_7939 adder) {
        adder.method_47613((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Rotations"), this.field_22793), 3);
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"X"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Y"), this.field_22793));
        adder.method_47612((class_8021)new class_7842((class_2561)class_2561.method_43470((String)"Z"), this.field_22793));
        class_342 xRotationField = this.newFloatField(class_2561.method_30163((String)"X Rotation"), () -> Float.valueOf(this.config.xRotation), newValue -> {
            this.config.xRotation = newValue;
        });
        class_342 yRotationField = this.newFloatField(class_2561.method_30163((String)"Y Rotation"), () -> Float.valueOf(this.config.yRotation), newValue -> {
            this.config.yRotation = newValue;
        });
        class_342 zRotationField = this.newFloatField(class_2561.method_30163((String)"Z Rotation"), () -> Float.valueOf(this.config.zRotation), newValue -> {
            this.config.zRotation = newValue;
        });
        adder.method_47612((class_8021)xRotationField);
        adder.method_47612((class_8021)yRotationField);
        adder.method_47612((class_8021)zRotationField);
    }

    private void addFinalButtons(class_7845.class_7939 adder) {
        class_4185 saveButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> this.saveAndClose()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Saves the values and closes the screen."))).method_46432(50).method_46431();
        class_4185 revertButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Revert"), button -> this.revert()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Reverts any edits made."))).method_46432(50).method_46431();
        class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> this.reset()).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Resets all values to their defaults."))).method_46432(50).method_46431();
        adder.method_47612((class_8021)saveButton);
        adder.method_47612((class_8021)revertButton);
        adder.method_47612((class_8021)resetButton);
    }

    private class_342 newFloatField(class_2561 text, Supplier<Float> getter, FloatConsumer setter) {
        class_342 textField = new class_342(this.field_22793, 50, 20, text);
        textField.method_1852(String.valueOf(getter.get()));
        textField.method_1890(FLOAT_INPUT_REGEX);
        textField.method_1863(input -> this.handleFloatInput(textField, (String)input, setter));
        return textField;
    }

    private void handleFloatInput(class_342 textField, String input, FloatConsumer setter) {
        try {
            float value = Float.parseFloat(input);
            if (!Float.isNaN(value) && Float.isFinite(value)) {
                setter.accept(value);
                textField.method_1868(-2039584);
            } else {
                textField.method_1868(class_9848.method_61334((int)class_124.field_1061.method_532()));
            }
        }
        catch (NumberFormatException e) {
            textField.method_1868(class_9848.method_61334((int)class_124.field_1061.method_532()));
        }
        this.hasChanges = !this.config.equals(this.backup);
    }

    private class_8030 getEffectiveDimensions(int scaledWindowWidth, int scaledWindowHeight) {
        boolean isMainHand = this.hand == class_1268.field_5808;
        int x = isMainHand ? 0 : scaledWindowWidth / 2;
        int width = scaledWindowWidth / 2;
        return new class_8030(new class_8029(x, 0), width, scaledWindowHeight);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        class_8030 dimensions = this.getEffectiveDimensions(this.field_22789, this.field_22790);
        context.method_44379(dimensions.method_49620(), dimensions.method_49618(), dimensions.method_49621(), dimensions.method_49619());
        GuiHelper.enableBlurScissor(dimensions.method_49620(), dimensions.method_49618(), dimensions.comp_1196(), dimensions.comp_1197());
        this.method_57734(context);
        this.method_57735(context);
        context.method_44380();
        boolean isMainHand = this.hand == class_1268.field_5808;
        context.method_51742(isMainHand ? dimensions.method_49621() : dimensions.method_49620(), dimensions.method_49618() - 1, dimensions.method_49619(), OUTLINE_COLOUR);
        context.method_51742(isMainHand ? dimensions.method_49621() - 1 : dimensions.method_49620() + 1, dimensions.method_49618() - 1, dimensions.method_49619(), INNER_OUTLINE_COLOUR);
    }

    private void saveAndClose() {
        AaronModConfigManager.save();
        this.hasChanges = false;
        this.method_25419();
    }

    private void revert() {
        this.config.copyFrom(this.backup);
        this.hasChanges = false;
        this.method_41843();
    }

    private void reset() {
        this.config.copyFrom(new ItemModelConfig.AbstractHand());
        this.hasChanges = true;
        this.method_41843();
    }

    public void method_25419() {
        if (this.hasChanges) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                if (confirmed) {
                    this.revert();
                    this.field_22787.method_1507(this.parent);
                } else {
                    this.field_22787.method_1507((class_437)this);
                }
            }, (class_2561)class_2561.method_43470((String)"Unsaved Changes"), (class_2561)class_2561.method_43470((String)"Are you sure you want to exit this screen? Any changes will not be saved!"), (class_2561)class_2561.method_43470((String)"Quit & Discard Changes"), class_5244.field_24335));
        } else {
            this.field_22787.method_1507(this.parent);
        }
    }
}

