/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.skyblock.entity;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.skyblock.entity.MobGlowAdder;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.RenderStateDataKey;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1531;

public class MobGlow {
    public static final int NO_GLOW = 0;
    public static final RenderStateDataKey<Integer> ENTITY_CUSTOM_GLOW_COLOUR = RenderStateDataKey.create(() -> "Aaron Mod custom glow colour");
    public static final RenderStateDataKey<Boolean> FRAME_USES_CUSTOM_GLOW = RenderStateDataKey.create(() -> "Aaron Mod frame uses custom glow");
    private static final List<MobGlowAdder> ADDERS = new ArrayList<MobGlowAdder>();
    private static final Object2IntMap<class_1297> CACHE = new Object2IntOpenHashMap();

    @Init
    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(_client -> MobGlow.reset());
    }

    protected static void registerGlowAdder(MobGlowAdder adder) {
        ADDERS.add(adder);
    }

    public static boolean hasOrComputeMobGlow(class_1297 entity) {
        if (CACHE.containsKey((Object)entity)) {
            return true;
        }
        int colour = MobGlow.computeMobGlow(entity);
        if (colour != 0) {
            CACHE.put((Object)entity, colour);
            return true;
        }
        return false;
    }

    public static int getMobGlowOrDefault(class_1297 entity, int defaultColour) {
        return CACHE.getOrDefault((Object)entity, defaultColour);
    }

    public static int getMobGlow(class_1297 entity) {
        return CACHE.getInt((Object)entity);
    }

    private static int computeMobGlow(class_1297 entity) {
        for (MobGlowAdder adder : ADDERS) {
            int glowColour;
            if (!adder.isEnabled() || (glowColour = adder.computeColour(entity)) == 0) continue;
            return glowColour;
        }
        return 0;
    }

    private static void reset() {
        CACHE.clear();
    }

    public static List<class_1531> getNearbyArmourStands(class_1297 entity) {
        return entity.method_73183().method_8390(class_1531.class, entity.method_5829().method_1009(0.0, 2.0, 0.0), class_1301.field_6153);
    }
}

