/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.skyblock.item;

import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.skyblock.item.Accessory;
import net.azureaaron.mod.skyblock.item.MagicalPower;
import net.azureaaron.mod.utils.Http;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

public class Accessories {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static @Unmodifiable Map<String, Accessory> accessories = Map.of();
    private static @Unmodifiable Map<String, MagicalPower> magicalPowers = Map.of();

    @Init
    public static void init() {
        Accessories.loadAccessories();
        Accessories.loadMagicalPowers();
    }

    private static void loadAccessories() {
        CompletableFuture.runAsync(() -> {
            if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
                try {
                    Map parsedAccessories;
                    String response = Http.sendGetRequest("https://api.azureaaron.net/skyblock/accessories");
                    accessories = parsedAccessories = (Map)Accessory.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)response)).getOrThrow();
                }
                catch (Exception e) {
                    LOGGER.error("[Aaron's Mod Accessories] Failed to download accessories!", (Throwable)e);
                }
            }
        });
    }

    private static void loadMagicalPowers() {
        CompletableFuture.runAsync(() -> {
            if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
                try {
                    Map parsedMagicalPowers;
                    String response = Http.sendGetRequest("https://api.azureaaron.net/skyblock/magicalpowers");
                    magicalPowers = parsedMagicalPowers = (Map)MagicalPower.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)response)).getOrThrow();
                }
                catch (Exception e) {
                    LOGGER.error("[Aaron's Mod Accessories] Failed to download magical powers!", (Throwable)e);
                }
            }
        });
    }

    public static Map<String, Accessory> getAccessories() {
        return accessories;
    }

    public static Map<String, MagicalPower> getMagicalPowers() {
        return magicalPowers;
    }
}

