/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.skyblock.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import net.azureaaron.mod.utils.CodecUtils;

public record SkyblockEnchantment(String id, String name, int maxLevel, OptionalInt goodLevel, Optional<List<String>> conflicts) {
    private static final Codec<SkyblockEnchantment> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(SkyblockEnchantment::id), (App)Codec.STRING.fieldOf("name").forGetter(SkyblockEnchantment::name), (App)Codec.INT.fieldOf("maxLevel").forGetter(SkyblockEnchantment::maxLevel), (App)CodecUtils.optionalInt((MapCodec<Optional<Integer>>)Codec.INT.optionalFieldOf("goodLevel")).forGetter(SkyblockEnchantment::goodLevel), (App)Codec.STRING.listOf().optionalFieldOf("conflicts").forGetter(SkyblockEnchantment::conflicts)).apply((Applicative)instance, SkyblockEnchantment::new));
    public static final Codec<Map<String, SkyblockEnchantment>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC);

    public boolean isAtMaxLevel(int level) {
        return level >= this.maxLevel;
    }

    public boolean isAtGoodLevel(int level) {
        return this.goodLevel.isPresent() && level >= this.goodLevel.getAsInt() && !this.isAtMaxLevel(level);
    }

    public boolean isAtGoodOrMaxLevel(int level) {
        return this.isAtMaxLevel(level) || this.isAtGoodLevel(level);
    }

    public boolean conflictsWith(String other) {
        return this.conflicts.isPresent() && this.conflicts.get().contains(other);
    }

    public static enum Type {
        NORMAL,
        ULTIMATE,
        STACKING;

    }
}

