/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.skyblock.item;

import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.skyblock.item.SkyblockEnchantment;
import net.azureaaron.mod.utils.Http;
import org.jetbrains.annotations.Unmodifiable;
import org.slf4j.Logger;

public class SkyblockEnchantments {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static @Unmodifiable Map<String, SkyblockEnchantment> enchantments = Map.of();

    @Init
    public static void init() {
        SkyblockEnchantments.loadEnchantments(false);
    }

    public static void loadEnchantments(boolean loadAnyways) {
        CompletableFuture.runAsync(() -> {
            if (enchantments.isEmpty() && (AaronModConfigManager.get().skyblock.enchantments.rainbowMaxEnchants || loadAnyways)) {
                try {
                    Map parsedEnchantments;
                    String response = Http.sendGetRequest("https://api.azureaaron.net/skyblock/enchantments");
                    enchantments = parsedEnchantments = (Map)SkyblockEnchantment.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)response)).getOrThrow();
                }
                catch (Exception e) {
                    LOGGER.error("[Aaron's Mod Enchantments] Failed to download skyblock enchantments!", (Throwable)e);
                }
            }
        });
    }

    public static Map<String, SkyblockEnchantment> getEnchantments() {
        return enchantments;
    }
}

