/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.azureaaron.mod.Main;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.debug.Debug;
import net.azureaaron.mod.mixins.accessors.MinecraftClientAccessor;
import net.azureaaron.mod.utils.Constants;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.Scheduler;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4844;
import net.minecraft.class_5699;
import net.minecraft.class_7427;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ApiAuthentication {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String MINECRAFT_VERSION = class_155.method_16673().comp_4025();
    private static final String AUTH_URL = "https://api.azureaaron.net/authenticate";
    private static final String CONTENT_TYPE = "application/json";
    private static final String ALGORITHM = "SHA256withRSA";
    private static final String NO_PROFILE_KEYS = "Failed to get your profile keys! Some features of the mod may not work temporarily :( (Has your game been open for more than 24 hours?). To fix this restart your game!";
    private static final String AUTH_FAILURE = "Failed to refresh your Aaron Mod API token, some features may not work temporarily!";
    private static TokenInfo tokenInfo = null;
    private static boolean sentWarningOnce = false;

    @Init
    public static void init() {
        if (AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            ClientLifecycleEvents.CLIENT_STARTED.register(_client -> ApiAuthentication.updateToken());
        }
        if (Debug.debugEnabled()) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"aaronmod").then(ClientCommandManager.literal((String)"updateToken").executes(source -> {
                ApiAuthentication.updateToken();
                return 1;
            }))));
        }
    }

    private static void updateToken() {
        ((CompletableFuture)((MinecraftClientAccessor)CLIENT).getProfileKeys().method_46522().thenAcceptAsync(playerKeypairOpt -> {
            boolean expired = playerKeypairOpt.map(keyPair -> keyPair.comp_742().comp_767().method_43704()).orElse(false);
            if (playerKeypairOpt.isPresent() && !expired) {
                class_7427 playerKeyPair = (class_7427)playerKeypairOpt.get();
                String publicKey = Base64.getMimeEncoder().encodeToString(playerKeyPair.comp_742().comp_767().comp_770().getEncoded());
                byte[] publicKeySignature = playerKeyPair.comp_742().comp_767().comp_771();
                long expiresAt = playerKeyPair.comp_742().comp_767().comp_769().toEpochMilli();
                TokenRequest.KeyPairInfo keyPairInfo = new TokenRequest.KeyPairInfo(Objects.requireNonNull(CLIENT.method_1548().method_44717()), publicKey, publicKeySignature, expiresAt);
                TokenRequest.SignedData signedData = Objects.requireNonNull(ApiAuthentication.getRandomSignedData(playerKeyPair.comp_741()));
                TokenRequest tokenRequest = new TokenRequest(keyPairInfo, signedData, Main.MOD_CONTAINER.getMetadata().getId(), MINECRAFT_VERSION, Main.MOD_VERSION);
                String request = Main.GSON.toJson((JsonElement)TokenRequest.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)tokenRequest).getOrThrow());
                try {
                    tokenInfo = (TokenInfo)TokenInfo.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)Http.sendPostRequest(AUTH_URL, request, CONTENT_TYPE))).getOrThrow();
                    int refreshAtTicks = (int)((tokenInfo.expiresAt() - tokenInfo.issuedAt()) / 1000L - 300L) * 20;
                    LOGGER.info("[Aaron's Mod Api Auth] Successfully refreshed api token.");
                    CLIENT.method_63588(() -> Scheduler.INSTANCE.schedule(ApiAuthentication::updateToken, refreshAtTicks, true));
                }
                catch (Exception e) {
                    ApiAuthentication.logErrorAndScheduleRetry((class_2561)class_2561.method_43470((String)AUTH_FAILURE), 18000, "[Aaron's Mod Api Auth] Failed to refresh the api token! Some features might not work :(", e);
                }
            } else {
                ApiAuthentication.logErrorAndScheduleRetry((class_2561)class_2561.method_43470((String)NO_PROFILE_KEYS), expired ? -1 : 6000, "[Aaron's Mod Api Auth] Failed to fetch profile keys! Some features may not work temporarily :( (Has your game been open for more than 24 hours? If so restart.)", new Object[0]);
            }
        })).exceptionally(throwable -> {
            ApiAuthentication.logErrorAndScheduleRetry((class_2561)class_2561.method_43470((String)AUTH_FAILURE), 6000, "[Aaron's Mod Api Auth] Encountered an unexpected exception while refreshing the api token!", throwable);
            return null;
        });
    }

    private static TokenRequest.SignedData getRandomSignedData(PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(ALGORITHM);
            UUID uuid = UUID.randomUUID();
            ByteBuffer buf = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits());
            signature.initSign(privateKey);
            signature.update(buf.array());
            byte[] signedData = signature.sign();
            return new TokenRequest.SignedData(buf.array(), signedData);
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Api Auth] Failed to sign random data!", (Throwable)e);
            return null;
        }
    }

    private static void logErrorAndScheduleRetry(class_2561 warningMessage, int retryAfter, String logMessage, Object ... logArgs) {
        LOGGER.error(logMessage, logArgs);
        if (retryAfter != -1) {
            CLIENT.method_63588(() -> Scheduler.INSTANCE.schedule(ApiAuthentication::updateToken, retryAfter, true));
        }
        if (ApiAuthentication.CLIENT.field_1724 != null && !sentWarningOnce) {
            ApiAuthentication.CLIENT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852(warningMessage), false);
            sentWarningOnce = true;
        }
    }

    @Nullable
    public static String getToken() {
        return tokenInfo != null ? tokenInfo.token() : null;
    }

    private record TokenRequest(KeyPairInfo keyPairInfo, SignedData signedData, String mod, String minecraftVersion, String modVersion) {
        private static final Codec<TokenRequest> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)KeyPairInfo.CODEC.fieldOf("keyPair").forGetter(TokenRequest::keyPairInfo), (App)SignedData.CODEC.fieldOf("signedData").forGetter(TokenRequest::signedData), (App)Codec.STRING.fieldOf("mod").forGetter(TokenRequest::mod), (App)Codec.STRING.fieldOf("minecraftVersion").forGetter(TokenRequest::minecraftVersion), (App)Codec.STRING.fieldOf("modVersion").forGetter(TokenRequest::modVersion)).apply((Applicative)instance, TokenRequest::new));

        private record KeyPairInfo(UUID uuid, String publicKey, byte[] publicKeySignature, long expiresAt) {
            private static final Codec<KeyPairInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_41525.fieldOf("uuid").forGetter(KeyPairInfo::uuid), (App)Codec.STRING.fieldOf("publicKey").forGetter(KeyPairInfo::publicKey), (App)class_5699.field_39273.fieldOf("publicKeySignature").forGetter(KeyPairInfo::publicKeySignature), (App)Codec.LONG.fieldOf("expiresAt").forGetter(KeyPairInfo::expiresAt)).apply((Applicative)instance, KeyPairInfo::new));
        }

        private record SignedData(byte[] original, byte[] signed) {
            private static final Codec<SignedData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_39273.fieldOf("original").forGetter(SignedData::original), (App)class_5699.field_39273.fieldOf("signed").forGetter(SignedData::signed)).apply((Applicative)instance, SignedData::new));
        }
    }

    private record TokenInfo(String token, long issuedAt, long expiresAt) {
        private static final Codec<TokenInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("token").forGetter(TokenInfo::token), (App)Codec.LONG.fieldOf("issuedAt").forGetter(TokenInfo::issuedAt), (App)Codec.LONG.fieldOf("expiresAt").forGetter(TokenInfo::expiresAt)).apply((Applicative)instance, TokenInfo::new));
    }
}

