/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.util.UndashedUuid;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.azureaaron.mod.utils.Functions;
import net.azureaaron.mod.utils.Http;
import net.minecraft.class_310;
import net.minecraft.class_5699;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ApiUtils {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 CLIENT = class_310.method_1551();
    private static final LoadingCache<String, ProfileResult> GAME_PROFILE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ProfileResult>(){

        public ProfileResult load(String key) throws Exception {
            return ApiUtils.getProfileInternal(key, 0);
        }
    });

    @Nullable
    public static GameProfile getProfile(String nameOrUuid) {
        return ((ProfileResult)GAME_PROFILE_CACHE.getUnchecked((Object)nameOrUuid.replace("-", ""))).profile();
    }

    @Nullable
    public static GameProfile getProfile(UUID uuid) {
        return ((ProfileResult)GAME_PROFILE_CACHE.getUnchecked((Object)UndashedUuid.toString((UUID)uuid))).profile();
    }

    private static ProfileResult getProfileInternal(String key, int retries) {
        boolean isUuid = Functions.isUuid(key);
        if (CLIENT.method_1548().method_1676().equalsIgnoreCase(key) || UndashedUuid.toString((UUID)CLIENT.method_1548().method_44717()).equalsIgnoreCase(key)) {
            return new ProfileResult(CLIENT.method_53462());
        }
        try {
            Http.ApiResponse response;
            Http.ApiResponse apiResponse = response = isUuid ? Http.sendUuidToNameRequest(key) : Http.sendNameToUuidRequest(key);
            if (response.ok()) {
                GameProfile profile = (GameProfile)class_5699.field_62069.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)response.content())).getOrThrow();
                return new ProfileResult(profile);
            }
            if (response.ratelimited() && retries < 3) {
                Thread.sleep(800L);
                return ApiUtils.getProfileInternal(key, ++retries);
            }
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Api Utils] Failed to lookup the GameProfile for the key {}.", (Object)key, (Object)e);
        }
        return new ProfileResult(null);
    }
}

