/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import ca.weblite.objc.Client;
import com.ibm.icu.text.DateTimePatternGenerator;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.SequencedCollection;
import java.util.concurrent.TimeUnit;
import net.azureaaron.mod.debug.Debug;
import net.minecraft.class_11906;
import net.minecraft.class_156;
import org.jetbrains.annotations.VisibleForTesting;

public class Formatters {
    public static final NumberFormat INTEGER_NUMBERS = NumberFormat.getIntegerInstance(Locale.CANADA);
    public static final NumberFormat DOUBLE_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getInstance(Locale.CANADA), nf -> nf.setMaximumFractionDigits(2));
    public static final NumberFormat FLOAT_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getInstance(Locale.CANADA), nf -> nf.setMaximumFractionDigits(1));
    public static final NumberFormat SHORT_INTEGER_NUMBERS = NumberFormat.getCompactNumberInstance(Locale.CANADA, NumberFormat.Style.SHORT);
    public static final NumberFormat SHORT_FLOAT_NUMBERS = (NumberFormat)class_156.method_654((Object)NumberFormat.getCompactNumberInstance(Locale.CANADA, NumberFormat.Style.SHORT), nf -> nf.setMinimumFractionDigits(1));
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("E MMM d yyyy " + Formatters.getTimeFormat(), Locale.US).withZone(Formatters.getTimeZone());

    public static RelativeTime toRelativeTime(long duration) {
        boolean future = Long.signum(duration) == -1;
        duration = Math.abs(duration);
        ArrayList<String> segments = new ArrayList<String>();
        for (Unit unit : Unit.UNITS) {
            long delta = duration / unit.millis();
            if (delta <= 0L) continue;
            String segment = delta + " " + unit.name() + (delta > 1L ? "s" : "");
            segments.add(segment);
            duration -= unit.millis() * delta;
        }
        String formatted = !segments.isEmpty() ? RelativeTime.joinSegments(segments, future) : "0 seconds ago";
        return new RelativeTime(segments, formatted, future);
    }

    private static String getTimeFormat() {
        return Formatters.is12HourClock() || Debug.isTestEnvironment() ? "h:mm:ss a" : "HH:mm:ss";
    }

    private static ZoneId getTimeZone() {
        return Debug.isTestEnvironment() ? ZoneId.of("UTC") : ZoneId.systemDefault();
    }

    private static boolean is12HourClock() {
        if (class_11906.field_62586) {
            Object locale = Client.getInstance().send("NSLocale", "currentLocale", new Object[0]);
            String timeFormat = (String)Client.getInstance().send("NSDateFormatter", "dateFormatFromTemplate:options:locale:", new Object[]{"j", 0, locale});
            return timeFormat.contains("a");
        }
        DateTimePatternGenerator generator = DateTimePatternGenerator.getInstance((Locale)Locale.getDefault());
        String timeFormat = generator.getBestPattern("j");
        return timeFormat.contains("a");
    }

    @VisibleForTesting
    protected record Unit(String name, long millis) {
        protected static final Unit YEAR = new Unit("year", TimeUnit.DAYS.toMillis(365L));
        protected static final Unit MONTH = new Unit("month", TimeUnit.DAYS.toMillis(30L));
        protected static final Unit WEEK = new Unit("week", TimeUnit.DAYS.toMillis(7L));
        protected static final Unit DAY = new Unit("day", TimeUnit.DAYS.toMillis(1L));
        protected static final Unit HOUR = new Unit("hour", TimeUnit.HOURS.toMillis(1L));
        protected static final Unit MINUTE = new Unit("minute", TimeUnit.MINUTES.toMillis(1L));
        protected static final Unit SECOND = new Unit("second", TimeUnit.SECONDS.toMillis(1L));
        private static final List<Unit> UNITS = List.of(YEAR, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND);
    }

    public record RelativeTime(SequencedCollection<String> segments, String formatted, boolean future) {
        public String greatest() {
            return !this.segments.isEmpty() ? this.segments.getFirst() + (this.future ? "" : " ago") : this.formatted;
        }

        public String atMost(int max) {
            if (this.segments.isEmpty()) {
                return this.formatted;
            }
            long min = 0L;
            List<String> applicableSegments = this.segments.stream().skip(0L).limit((long)max - 0L).toList();
            return RelativeTime.joinSegments(applicableSegments, this.future);
        }

        private static String joinSegments(SequencedCollection<String> segments, boolean future) {
            return String.join((CharSequence)", ", segments) + (future ? "" : " ago");
        }
    }
}

