/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import net.azureaaron.mod.Main;
import net.azureaaron.mod.utils.ApiAuthentication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Http {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).followRedirects(HttpClient.Redirect.NORMAL).build();
    private static final String HYPIXEL_PROXY = "https://api.azureaaron.net/hypixel/v2/";
    private static final String NAME_TO_UUID = "https://api.minecraftservices.com/minecraft/profile/lookup/name/";
    private static final String UUID_TO_NAME = "https://api.minecraftservices.com/minecraft/profile/lookup/";
    private static final String USER_AGENT = "Aaron's Mod/" + Main.MOD_VERSION + " (" + Main.MINECRAFT_VERSION + ")";

    private static ApiResponse sendGetRequestInternal(String url, @Nullable String apiToken) throws IOException, InterruptedException {
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().GET().header("Accept", "application/json").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(URI.create(url));
        if (apiToken != null) {
            requestBuilder.header("Authorization", "Bearer " + apiToken);
        }
        HttpResponse<InputStream> response = HTTP_CLIENT.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        try (InputStream decodedInputStream = Http.getDecodedInputStream(response);){
            String body = new String(decodedInputStream.readAllBytes());
            ApiResponse apiResponse = new ApiResponse(body, response.statusCode(), url, response.headers());
            return apiResponse;
        }
    }

    public static String sendGetRequest(@NotNull String url) throws IOException, InterruptedException {
        return Http.sendGetRequestInternal(url, null).content();
    }

    public static String sendHypixelRequest(@NotNull String endpoint, @NotNull String parameters) throws IOException, InterruptedException, ApiException {
        ApiResponse response = Http.sendGetRequestInternal(HYPIXEL_PROXY + endpoint + parameters, ApiAuthentication.getToken());
        response.tryThrow();
        return response.content();
    }

    public static ApiResponse sendNameToUuidRequest(@NotNull String name) throws IOException, InterruptedException, ApiException {
        return Http.sendGetRequestInternal(NAME_TO_UUID + name, null);
    }

    public static ApiResponse sendUuidToNameRequest(@NotNull String uuid) throws IOException, InterruptedException, ApiException {
        return Http.sendGetRequestInternal(UUID_TO_NAME + uuid, null);
    }

    public static String sendPostRequest(@NotNull String url, @NotNull String requestBody, @NotNull String contentType) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(requestBody)).header("Accept", contentType).header("Accept-Encoding", "gzip, deflate").header("Content-Type", contentType).header("User-Agent", USER_AGENT).uri(URI.create(url)).build();
        HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
        try (InputStream decodedInputStream = Http.getDecodedInputStream(response);){
            String body;
            String string = body = new String(decodedInputStream.readAllBytes());
            return string;
        }
    }

    public static InputStream sendGenericH2Request(URI uri, ImmutableSet<String> expectedContentTypes) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().GET().header("Accept", "*/*").header("Accept-Encoding", "gzip, deflate").header("User-Agent", USER_AGENT).version(HttpClient.Version.HTTP_2).uri(uri).build();
        HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
        int statusCode = response.statusCode();
        String contentType = Http.getContentType(response);
        if (statusCode != 200) {
            throw new IllegalStateException("Request was unsuccessful! Code: " + statusCode);
        }
        if (!expectedContentTypes.contains((Object)contentType)) {
            throw new IllegalStateException("Unexpected content type received! Content Type: " + contentType);
        }
        return Http.getDecodedInputStream(response);
    }

    private static InputStream getDecodedInputStream(HttpResponse<InputStream> response) {
        String encoding = Http.getContentEncoding(response);
        try {
            return switch (encoding) {
                case "" -> response.body();
                case "gzip" -> new GZIPInputStream(response.body());
                case "deflate" -> new InflaterInputStream(response.body());
                default -> throw new UnsupportedOperationException("The server sent content in unexpected encoding: " + encoding);
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String getContentEncoding(HttpResponse<InputStream> response) {
        return response.headers().firstValue("Content-Encoding").orElse("");
    }

    private static String getContentType(HttpResponse<InputStream> response) {
        return response.headers().firstValue("Content-Type").orElse("");
    }

    public record ApiResponse(String content, int statusCode, String url, HttpHeaders headers) {
        public boolean ok() {
            return this.statusCode == 200;
        }

        public boolean ratelimited() {
            return this.statusCode == 429;
        }

        public ApiException createException() {
            return new ApiException("[Aaron's Mod] API Error! URL: " + this.url + ", Code: " + this.statusCode + ", Body: " + this.content);
        }

        public void tryThrow() throws ApiException {
            if (!this.ok()) {
                throw this.createException();
            }
        }
    }

    public static class ApiException
    extends Exception {
        private static final long serialVersionUID = 2804124614055383667L;

        public ApiException(String errorMessage) {
            super(errorMessage);
        }
    }
}

