/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ImageMetadata {
    private static final long PNG_SIGNATURE = -8552249625308161526L;

    public static boolean validateGif(ByteBuffer buf) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.BIG_ENDIAN);
        byte[] bytes = new byte[6];
        buf.get(0, bytes, 0, 6);
        buf.order(byteOrder);
        return bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70 && bytes[3] == 56 && (bytes[4] == 55 || bytes[4] == 57) && bytes[5] == 97;
    }

    public static boolean validateJpeg(ByteBuffer buf) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.BIG_ENDIAN);
        byte[] bytes = new byte[2];
        buf.get(0, bytes, 0, 2);
        buf.order(byteOrder);
        return (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 216;
    }

    public static boolean validatePng(ByteBuffer buf) {
        ByteOrder byteOrder = buf.order();
        buf.order(ByteOrder.BIG_ENDIAN);
        long signature = buf.getLong(0);
        int iHdrChunkLength = buf.getInt(8);
        int iHdrChunkType = buf.getInt(12);
        buf.order(byteOrder);
        return signature == -8552249625308161526L && iHdrChunkLength == 13 && iHdrChunkType == 1229472850;
    }
}

