/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import net.minecraft.class_6328;

@class_6328
public class JsonHelper {
    public static OptionalInt getInt(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsInt).map(OptionalInt::of).orElseGet(OptionalInt::empty);
    }

    public static OptionalLong getLong(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsLong).map(OptionalLong::of).orElseGet(OptionalLong::empty);
    }

    public static Optional<Float> getFloat(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsFloat);
    }

    public static OptionalDouble getDouble(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsDouble).map(OptionalDouble::of).orElseGet(OptionalDouble::empty);
    }

    public static Optional<Boolean> getBoolean(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsBoolean);
    }

    public static Optional<String> getString(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsString);
    }

    public static Optional<JsonObject> getObject(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsJsonObject);
    }

    public static Optional<JsonArray> getArray(JsonObject root, String path) {
        return JsonHelper.getElement(root, path, JsonElement::getAsJsonArray);
    }

    private static <T> Optional<T> getElement(JsonObject root, String path, ValueExtractor<T> valueExtractor) {
        if (root == null) {
            return Optional.empty();
        }
        if (!path.contains(".")) {
            return root.has(path) && !root.get(path).isJsonNull() ? Optional.of(valueExtractor.to(root.get(path))) : Optional.empty();
        }
        String[] split = path.split("\\.");
        String propertyName = split[split.length - 1];
        String[] objects2Traverse = new String[split.length - 1];
        System.arraycopy(split, 0, objects2Traverse, 0, split.length - 1);
        JsonObject currentLevel = root;
        for (String objectName : objects2Traverse) {
            if (!currentLevel.has(objectName) || currentLevel.get(objectName).isJsonNull()) {
                return Optional.empty();
            }
            currentLevel = currentLevel.getAsJsonObject(objectName);
        }
        return currentLevel.has(propertyName) && !currentLevel.get(propertyName).isJsonNull() ? Optional.of(valueExtractor.to(currentLevel.get(propertyName))) : Optional.empty();
    }

    public static JsonElement clearNullValues(JsonElement rootElement) {
        JsonElement jsonElement = rootElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonObject.class, JsonArray.class}, (Object)jsonElement, n)) {
            case 0: {
                JsonObject object = (JsonObject)jsonElement;
                JsonObject newObject = new JsonObject();
                for (String key : object.keySet()) {
                    JsonElement element = JsonHelper.clearNullValues(object.get(key));
                    if (element == null) continue;
                    newObject.add(key, element);
                }
                return newObject;
            }
            case 1: {
                JsonArray array = (JsonArray)jsonElement;
                JsonArray newArray = new JsonArray();
                for (JsonElement item : array) {
                    JsonElement element = JsonHelper.clearNullValues(item);
                    if (element == null) continue;
                    newArray.add(element);
                }
                return newArray;
            }
            case -1: {
                return null;
            }
        }
        return rootElement.isJsonNull() ? null : rootElement;
    }

    @FunctionalInterface
    private static interface ValueExtractor<R> {
        public R to(JsonElement var1);
    }
}

