/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;

public class RomanNumerals {
    private static final Int2ObjectMap<String> ROMAN_NUMERAL_VALUES = Int2ObjectMaps.unmodifiable((Int2ObjectMap)new Int2ObjectLinkedOpenHashMap(new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1}, (Object[])new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"}));

    public static String toRoman(int number) {
        if (number <= 0 || number >= 4000) {
            return "";
        }
        StringBuilder roman = new StringBuilder();
        for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(ROMAN_NUMERAL_VALUES)) {
            while (number >= entry.getIntKey()) {
                roman.append((String)entry.getValue());
                number -= entry.getIntKey();
            }
        }
        return roman.toString();
    }
}

