/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.IntFunction;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.minecraft.class_10209;
import net.minecraft.class_3695;

public class Scheduler {
    public static final Scheduler INSTANCE = new Scheduler();
    private static final IntFunction<ArrayList<Runnable>> NEW_TASK_LIST = _int -> new ArrayList();
    private final Int2ObjectMap<List<Runnable>> tasks = new Int2ObjectOpenHashMap();
    private int currentTick = 0;

    private Scheduler() {
    }

    public void schedule(Runnable task, int delay) {
        this.schedule(task, delay, false);
    }

    public void schedule(Runnable task, int delay, boolean multithreaded) {
        Objects.requireNonNull(task, "Cannot schedule a null task!");
        Preconditions.checkArgument((delay >= 0 ? 1 : 0) != 0, (Object)"Cannot schedule a task in the past!");
        RenderHelper.assertOnRenderThread("Scheduler called from outside the Render Thread");
        this.addTask(new Task(task, delay, false, multithreaded), this.currentTick + delay);
    }

    public void scheduleCyclic(Runnable task, int period) {
        this.scheduleCyclic(task, period, false);
    }

    public void scheduleCyclic(Runnable task, int period, boolean multithreaded) {
        Objects.requireNonNull(task, "Cannot schedule a null task!");
        Preconditions.checkArgument((period >= 1 ? 1 : 0) != 0, (Object)"Cannot schedule a cyclic task with a period shorter than 1!");
        RenderHelper.assertOnRenderThread("Scheduler called from outside the Render Thread");
        this.addTask(new Task(task, period, true, multithreaded), this.currentTick);
    }

    public void tick() {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("aaronModSchedulerTick");
        if (this.tasks.containsKey(this.currentTick)) {
            List tasks4Tick = (List)this.tasks.get(this.currentTick);
            for (Runnable task : tasks4Tick) {
                task.run();
            }
            this.tasks.remove(this.currentTick);
        }
        ++this.currentTick;
        profiler.method_15407();
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    private void addTask(Runnable task, int ticks) {
        ((List)this.tasks.computeIfAbsent(ticks, NEW_TASK_LIST)).add(task);
    }

    private record Task(Runnable task, int period, boolean cyclic, boolean multithreaded) implements Runnable
    {
        @Override
        public void run() {
            if (this.multithreaded) {
                CompletableFuture.runAsync(this.task);
            } else {
                this.task.run();
            }
            if (this.cyclic) {
                INSTANCE.addTask(this, Scheduler.INSTANCE.currentTick + this.period);
            }
        }
    }
}

