/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.common.collect.EvictingQueue;
import java.util.Queue;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.events.ServerTickCallback;
import net.azureaaron.mod.utils.Scheduler;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientWorldEvents;
import net.minecraft.class_310;
import net.minecraft.class_6373;

public class ServerTickCounter {
    public static final ServerTickCounter INSTANCE = new ServerTickCounter();
    public static final long MILLIS_PER_TICK = 50L;
    private final Queue<Integer> tpsResults = EvictingQueue.create((int)12);
    private int totalTicks;
    private int lastParameter;
    private boolean receivedPacketThisTick;
    private int ticksWithPacketsSent;
    private double tickRate;
    private long lastWorldChange;

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(INSTANCE::onClientTick, 1);
        Scheduler.INSTANCE.scheduleCyclic(INSTANCE::calculateTickRate, 20);
        ClientWorldEvents.AFTER_CLIENT_WORLD_CHANGE.register((client, world) -> INSTANCE.reset());
    }

    public void onServerTick(class_6373 packet) {
        if (packet.method_36950() != this.lastParameter) {
            ++this.totalTicks;
            this.lastParameter = packet.method_36950();
            ((ServerTickCallback)ServerTickCallback.EVENT.invoker()).onTick();
        }
    }

    private void calculateTickRate() {
        if (this.ticksWithPacketsSent > 0) {
            this.tpsResults.offer(this.ticksWithPacketsSent);
        }
        if (this.lastWorldChange + 5000L < System.currentTimeMillis()) {
            double tickRate = this.tpsResults.stream().mapToInt(Integer::intValue).average().orElse(0.0);
            this.tickRate = Math.clamp((double)Math.round(tickRate * 10.0) / 10.0, 0.0, 20.0);
            this.ticksWithPacketsSent = 0;
        }
    }

    private void onClientTick() {
        if (this.receivedPacketThisTick) {
            ++this.ticksWithPacketsSent;
            this.receivedPacketThisTick = false;
        }
    }

    public void onReceivePacket() {
        class_310.method_1551().method_63588(() -> {
            this.receivedPacketThisTick = true;
        });
    }

    private void reset() {
        this.tpsResults.clear();
        this.totalTicks = 0;
        this.lastParameter = 0;
        this.receivedPacketThisTick = false;
        this.ticksWithPacketsSent = 0;
        this.tickRate = 0.0;
        this.lastWorldChange = System.currentTimeMillis();
    }

    public int getTotalTicks() {
        return this.totalTicks;
    }

    public double getTickRate() {
        return this.tickRate;
    }
}

