/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.codecs.LootCodec;
import net.azureaaron.mod.utils.ItemUtils;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.Messages;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6903;
import org.slf4j.Logger;

public class Skyblock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean loaded;

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> CompletableFuture.allOf(Skyblock.loadRareLootItems(client)).whenComplete((_result, _throwable) -> {
            loaded = true;
        }));
    }

    private static CompletableFuture<Void> loadRareLootItems(class_310 client) {
        return CompletableFuture.supplyAsync(() -> {
            Map map;
            block8: {
                BufferedReader reader = client.method_1478().openAsReader(class_2960.method_60655((String)"aaron-mod", (String)"skyblock/rare_loot_items.json"));
                try {
                    class_6903 ops = ItemUtils.getRegistryLookup().method_57093((DynamicOps)JsonOps.INSTANCE);
                    map = (Map)LootCodec.RARE_LOOT_CODEC.parse((DynamicOps)ops, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow();
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("[Aaron's Mod] Failed to load rare loot items file!", (Throwable)e);
                        return Map.of();
                    }
                }
                reader.close();
            }
            return map;
        }).thenAccept(LootCodec.RARE_LOOT_ITEMS::putAll);
    }

    public static Map<String, class_1799> getRareLootItems() {
        return loaded ? LootCodec.RARE_LOOT_ITEMS : Map.of();
    }

    public static JsonObject getSelectedProfile2(String profiles) throws IllegalStateException {
        if (profiles == null) {
            return null;
        }
        JsonObject skyblockData = JsonParser.parseString((String)profiles).getAsJsonObject();
        if (skyblockData.get("profiles").isJsonNull()) {
            throw new IllegalStateException(Messages.NO_SKYBLOCK_PROFILES_ERROR.get().getString());
        }
        JsonArray profilesArray = skyblockData.getAsJsonArray("profiles");
        for (JsonElement profile : profilesArray) {
            JsonObject iteratedProfile = profile.getAsJsonObject();
            if (!iteratedProfile.get("selected").getAsBoolean()) continue;
            return iteratedProfile;
        }
        throw new IllegalStateException(Messages.PROFILES_NOT_MIGRATED_ERROR.get().getString());
    }

    public static boolean isInventoryApiEnabled(JsonObject inventoryData) {
        return inventoryData != null && inventoryData.has("inv_contents");
    }

    public static boolean isSkillsApiEnabled(JsonObject profile) {
        return profile.getAsJsonObject("player_data").has("experience");
    }

    public static String getDojoGrade(int score) {
        String string;
        Integer n = score;
        Objects.requireNonNull(n);
        Integer n2 = n;
        int n3 = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class}, (Object)n2, n3)) {
                case 0: {
                    Integer ignored5 = n2;
                    if (score != 0) {
                        n3 = 1;
                        continue block8;
                    }
                    string = "None";
                    break block8;
                }
                case 1: {
                    Integer ignored4 = n2;
                    if (score < 1000) {
                        n3 = 2;
                        continue block8;
                    }
                    string = "S";
                    break block8;
                }
                case 2: {
                    Integer ignored3 = n2;
                    if (score < 800) {
                        n3 = 3;
                        continue block8;
                    }
                    string = "A";
                    break block8;
                }
                case 3: {
                    Integer ignored2 = n2;
                    if (score < 600) {
                        n3 = 4;
                        continue block8;
                    }
                    string = "B";
                    break block8;
                }
                case 4: {
                    Integer ignored1 = n2;
                    if (score < 400) {
                        n3 = 5;
                        continue block8;
                    }
                    string = "C";
                    break block8;
                }
                case 5: {
                    Integer ignored = n2;
                    if (score < 200) {
                        n3 = 6;
                        continue block8;
                    }
                    string = "D";
                    break block8;
                }
                default: {
                    string = "F";
                    break block8;
                }
            }
            break;
        }
        return string;
    }

    public static int calculateProfileSocialXp(JsonObject profile) {
        int socialXp = 0;
        JsonObject members = profile.getAsJsonObject("members");
        for (String uuid : members.keySet()) {
            JsonObject member = members.getAsJsonObject(uuid);
            socialXp += JsonHelper.getInt(member, "player_data.experience.SKILL_SOCIAL").orElse(0);
        }
        return socialXp;
    }
}

