/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import net.azureaaron.mod.annotations.Init;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.Cache;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.mod.utils.networth.NetworthDataSuppliers;
import org.slf4j.Logger;

public class SkyblockItemData {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Init
    public static void init() {
        if (!AaronModConfigManager.get().skyblock.commands.enableSkyblockCommands) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject itemsResponse = JsonParser.parseString((String)Http.sendGetRequest("https://api.hypixel.net/v2/resources/skyblock/items")).getAsJsonObject();
                return JsonHelper.getArray(itemsResponse, "items").orElseGet(JsonArray::new);
            }
            catch (Exception e) {
                LOGGER.error("[Aaron's Mod Skyblock Item Data Loader] Failed to load Skyblock Item Data.", (Throwable)e);
                throw new IllegalStateException();
            }
        }).thenAcceptAsync(items -> {
            Cache.populate(items);
            NetworthDataSuppliers.updateSkyblockItemData(items);
        });
    }
}

