/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils;

import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.azureaaron.mod.utils.Functions;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_7417;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TextTransformer {
    private static final CharList FORMAT_CODES = CharList.of((char[])new char[]{'4', 'c', '6', 'e', '2', 'a', 'b', '3', '1', '9', 'd', '5', 'f', '7', '8', '0', 'r', 'k', 'l', 'm', 'n', 'o'});

    public static class_5250 fromLegacy(@NotNull String legacy) {
        class_5250 newText = class_2561.method_43473();
        StringBuilder builder = new StringBuilder();
        class_124 formatting = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        for (int i = 0; i < legacy.length(); ++i) {
            if (i != 0 && legacy.charAt(i - 1) == '\u00a7' && FORMAT_CODES.contains(Character.toLowerCase(legacy.charAt(i))) && !builder.isEmpty()) {
                newText.method_10852((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(class_2583.field_24360.method_10977(formatting).method_10982(Boolean.valueOf(bold)).method_10978(Boolean.valueOf(italic)).method_30938(Boolean.valueOf(underline)).method_36140(Boolean.valueOf(strikethrough)).method_36141(Boolean.valueOf(obfuscated))));
                builder.delete(0, builder.length());
                formatting = null;
                bold = false;
                italic = false;
                underline = false;
                strikethrough = false;
                obfuscated = false;
            }
            if (i != 0 && legacy.charAt(i - 1) == '\u00a7') {
                class_124 fmt = class_124.method_544((char)legacy.charAt(i));
                switch (fmt) {
                    case field_1067: {
                        bold = true;
                        break;
                    }
                    case field_1056: {
                        italic = true;
                        break;
                    }
                    case field_1073: {
                        underline = true;
                        break;
                    }
                    case field_1055: {
                        strikethrough = true;
                        break;
                    }
                    case field_1051: {
                        obfuscated = true;
                        break;
                    }
                    default: {
                        formatting = fmt;
                        break;
                    }
                }
                continue;
            }
            if (legacy.charAt(i) != '\u00a7' && (i == 0 || i != 0 && legacy.charAt(i - 1) != '\u00a7')) {
                builder.append(legacy.charAt(i));
            }
            if (i != legacy.length() - 1) continue;
            newText.method_10852((class_2561)class_2561.method_43470((String)builder.toString()).method_10862(class_2583.field_24360.method_10977(formatting).method_10982(Boolean.valueOf(bold)).method_10978(Boolean.valueOf(italic)).method_30938(Boolean.valueOf(underline)).method_36140(Boolean.valueOf(strikethrough)).method_36141(Boolean.valueOf(obfuscated))));
        }
        return newText;
    }

    public static class_2561 stylizeAndReplace(@NotNull class_2561 text, @NotNull class_2583 baseStyle, @NotNull String textToStylize, @NotNull class_2583 newStyle, @NotNull String[] replaceableText, @NotNull String replacementRegex, @NotNull String replacementText, int replacementMatches) {
        String stringForm = text.getString();
        if (Arrays.stream(replaceableText).anyMatch(stringForm::contains)) {
            List textComponents = text.method_10855();
            int textComponentCount = textComponents.size();
            class_5250 newText = class_2561.method_43473().method_10862(baseStyle);
            int replacementsMatched = 0;
            for (int i = 0; i < textComponentCount; ++i) {
                String componentString = ((class_2561)textComponents.get(i)).getString();
                if (componentString.contains(textToStylize) && replacementsMatched < replacementMatches) {
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString).method_10862(newStyle));
                    ++replacementsMatched;
                    continue;
                }
                if (Arrays.stream(replaceableText).anyMatch(componentString::contains)) {
                    if (replacementText.isEmpty()) continue;
                    class_2583 componentStyle = ((class_2561)textComponents.get(i)).method_10866();
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString.replaceAll(replacementRegex, replacementText)).method_10862(componentStyle));
                    continue;
                }
                newText.method_10852((class_2561)textComponents.get(i));
            }
            return newText;
        }
        return text;
    }

    public static class_2561 stylize(@NotNull class_2561 text, @NotNull class_2583 baseStyle, @NotNull String textToStylize, @NotNull class_2583 newStyle, int matches) {
        String stringForm = text.getString();
        if (stringForm.contains(textToStylize)) {
            List textComponents = text.method_10855();
            int textComponentCount = textComponents.size();
            class_5250 newText = class_2561.method_43473().method_10862(baseStyle);
            int partsMatched = 0;
            for (int i = 0; i < textComponentCount; ++i) {
                String componentString = ((class_2561)textComponents.get(i)).getString();
                if (componentString.contains(textToStylize) && partsMatched < matches) {
                    newText.method_10852((class_2561)class_2561.method_43470((String)componentString).method_10862(newStyle));
                    ++partsMatched;
                    continue;
                }
                newText.method_10852((class_2561)textComponents.get(i));
            }
            return newText;
        }
        return text;
    }

    public static class_2561 rainbowify(@NotNull String text) {
        class_5250 newText = class_2561.method_43473();
        float textLength = text.length();
        float next = Math.nextDown(1.0f) * textLength;
        newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(0))).method_54663(Functions.hsbToRGB(Math.nextDown(1.0f), 1.0f, 1.0f)));
        int i = 1;
        while ((float)i < textLength) {
            float i2 = i;
            newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_54663(Functions.hsbToRGB(i2 / next, 1.0f, 1.0f)));
            ++i;
        }
        return newText;
    }

    public static class_5250 progressivelyRainbowify(@NotNull String text, int totalTextLength, int positionLeftOffAt) {
        class_5250 newText = class_2561.method_43473();
        float next = Math.nextDown(1.0f) * (float)totalTextLength;
        newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(0))).method_54663(Functions.hsbToRGB((float)positionLeftOffAt / next, 1.0f, 1.0f)));
        for (int i = 1; i < text.length(); ++i) {
            float i2 = i + positionLeftOffAt;
            newText.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_54663(Functions.hsbToRGB(i2 / next, 1.0f, 1.0f)));
        }
        return newText;
    }

    public static class_5481 replaceInOrdered(class_5481 orderedText, String wantedWord, class_2561 replacementText) {
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        int startIndex = stringified.indexOf(wantedWord);
        int endIndex = startIndex + wantedWord.length();
        if (startIndex == -1) {
            return orderedText;
        }
        List textComponents = text.method_10855();
        textComponents.set(startIndex, replacementText);
        for (int i = endIndex - 1; i >= startIndex + 1; --i) {
            textComponents.remove(i);
        }
        return text.method_30937();
    }

    public static class_5481 replaceMultipleInOrdered(class_5481 orderedText, String wantedWord, class_2561 replacementText) {
        boolean occurs;
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        boolean bl = occurs = stringified.indexOf(wantedWord) != -1;
        if (!occurs) {
            return orderedText;
        }
        int occurrences = StringUtils.countMatches((CharSequence)stringified, (CharSequence)wantedWord);
        class_5250 newText = text;
        int indexFrom = 0;
        for (int i = 0; i < occurrences; ++i) {
            String currentString = newText.getString();
            int startIndex = currentString.indexOf(wantedWord, indexFrom);
            int endIndex = startIndex + wantedWord.length();
            if (startIndex == -1) break;
            List textComponents = newText.method_10855();
            textComponents.set(startIndex, replacementText);
            for (int i2 = endIndex - 1; i2 >= startIndex + 1; --i2) {
                textComponents.remove(i2);
            }
            newText = TextTransformer.deconstructComponents((class_2561)newText);
            int lengthDiff = newText.getString().length() - currentString.length();
            indexFrom = endIndex + lengthDiff;
        }
        return newText.method_30937();
    }

    public static class_5250 deconstructComponents(class_2561 text) {
        List currentComponents = text.method_10855();
        class_5250 newText = class_2561.method_43473();
        List newComponents = newText.method_10855();
        for (int i = 0; i < currentComponents.size(); ++i) {
            class_2561 current = (class_2561)currentComponents.get(i);
            String currentString = current.getString();
            if (currentString.length() <= 1) {
                newComponents.add(current);
                continue;
            }
            current.method_30937().accept((index, style, codePoint) -> {
                newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
                return true;
            });
        }
        return newText;
    }

    public static class_5250 deconstructAllComponents(class_2561 text) {
        List currentComponents = text.method_10855();
        class_5250 newText = class_2561.method_43473();
        List newComponents = newText.method_10855();
        text.method_30937().accept((index, style, codePoint) -> {
            newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        for (int i = 0; i < currentComponents.size(); ++i) {
            class_2561 current = (class_2561)currentComponents.get(i);
            String currentString = current.getString();
            if (currentString.length() <= 1) {
                newComponents.add(current);
                continue;
            }
            current.method_30937().accept((index, style, codePoint) -> {
                newComponents.add(class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
                return true;
            });
        }
        return newText;
    }

    public static class_5481 replaceMultipleEntriesInOrdered(class_5481 orderedText, Object2ObjectLinkedOpenHashMap<String, class_2561> replacements) {
        class_5250 text = class_2561.method_43473();
        orderedText.accept((index, style, codePoint) -> {
            text.method_10852((class_2561)class_2561.method_43470((String)Character.toString(codePoint)).method_10862(style));
            return true;
        });
        String stringified = text.getString();
        class_5250 newText = text;
        if (stringified.length() != text.method_10855().size()) {
            return orderedText;
        }
        block0: for (Map.Entry entry : replacements.entrySet()) {
            boolean occurs;
            String wantedWord = (String)entry.getKey();
            class_2561 replacementText = (class_2561)entry.getValue();
            boolean bl = occurs = stringified.indexOf(wantedWord) != -1;
            if (!occurs) continue;
            int occurrences = StringUtils.countMatches((CharSequence)stringified, (CharSequence)wantedWord);
            int indexFrom = 0;
            for (int i = 0; i < occurrences; ++i) {
                String currentString = newText.getString();
                int startIndex = currentString.indexOf(wantedWord, indexFrom);
                int endIndex = startIndex + wantedWord.length();
                if (startIndex == -1) continue block0;
                List textComponents = newText.method_10855();
                textComponents.set(startIndex, replacementText);
                for (int i2 = endIndex - 1; i2 >= startIndex + 1; --i2) {
                    textComponents.remove(i2);
                }
                newText = TextTransformer.deconstructComponents((class_2561)newText);
                int lengthDiff = newText.getString().length() - currentString.length();
                indexFrom = endIndex + lengthDiff;
            }
        }
        return newText.equals((Object)text) ? orderedText : newText.method_30937();
    }

    public static class_5250 recursiveCopy(class_2561 original) {
        class_5250 newText = class_5250.method_43477((class_7417)original.method_10851()).method_10862(original.method_10866());
        ((ArrayList)newText.method_10855()).ensureCapacity(original.method_10855().size());
        for (class_2561 sibling : original.method_10855()) {
            newText.method_10855().add(TextTransformer.recursiveCopy(sibling));
        }
        return newText;
    }

    public static class_5250 withContent(class_2561 original, String newContent) {
        class_5250 newText = class_2561.method_43470((String)newContent).method_10862(original.method_10866());
        newText.method_10855().addAll(original.method_10855());
        return newText;
    }
}

