/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils.networth;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMaps;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.stream.Collectors;
import net.azureaaron.mod.utils.CodecUtils;
import net.azureaaron.mod.utils.Http;
import net.azureaaron.mod.utils.JsonHelper;
import net.azureaaron.networth.data.SkyblockItemData;
import org.slf4j.Logger;

public class NetworthDataSuppliers {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Object2DoubleMap<String>> CODEC = CodecUtils.object2DoubleMap(Codec.STRING);
    private static final long FIVE_MINUTES = 300000L;
    private static Object2ObjectMap<String, SkyblockItemData> itemData = Object2ObjectMaps.emptyMap();
    private static Object2DoubleMap<String> lbinPrices = Object2DoubleMaps.emptyMap();
    private static Object2DoubleMap<String> bazaarPrices = Object2DoubleMaps.emptyMap();
    private static volatile long pricesLastUpdated;

    static double getPrice(String apiId) {
        NetworthDataSuppliers.tick();
        if (bazaarPrices.containsKey((Object)apiId)) {
            return bazaarPrices.getDouble((Object)apiId);
        }
        return lbinPrices.getDouble((Object)apiId);
    }

    static Object2ObjectMap<String, SkyblockItemData> getSkyblockItemData() {
        return itemData;
    }

    public static void updateSkyblockItemData(JsonArray items) {
        try {
            itemData = (Object2ObjectMap)SkyblockItemData.MAP_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)items).getOrThrow();
        }
        catch (Exception e) {
            LOGGER.error("[Aaron's Mod Networth Data Supplier] Failed to parse items data!", (Throwable)e);
        }
    }

    private static void tick() {
        if (System.currentTimeMillis() > pricesLastUpdated + 300000L) {
            try {
                String lbinPriceData = Http.sendGetRequest("https://hysky.de/api/auctions/lowestbins");
                Object2DoubleMap lbins = (Object2DoubleMap)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)lbinPriceData)).getOrThrow();
                JsonObject bazaarPriceData = JsonParser.parseString((String)Http.sendGetRequest("https://hysky.de/api/bazaar")).getAsJsonObject();
                Object2DoubleMap bazaar = (Object2DoubleMap)bazaarPriceData.asMap().entrySet().stream().map(e -> Pair.of((Object)((String)e.getKey()), (Object)((JsonElement)e.getValue()).getAsJsonObject())).collect(Collectors.toMap(Pair::left, p -> JsonHelper.getDouble((JsonObject)p.right(), "buyPrice").orElse(0.0), (a, b) -> a, Object2DoubleOpenHashMap::new));
                lbinPrices = lbins;
                bazaarPrices = bazaar;
                pricesLastUpdated = System.currentTimeMillis();
            }
            catch (Exception e2) {
                LOGGER.error("[Aaron's Mod Networth Data Supplier] Failed to update prices!", (Throwable)e2);
            }
        }
    }
}

