/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils.render.hud;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.azureaaron.dandelion.systems.ButtonOption;
import net.azureaaron.mod.config.AaronModConfigManager;
import net.azureaaron.mod.utils.render.RenderHelper;
import net.azureaaron.mod.utils.render.hud.HudElement;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public final class HudElementConfigScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_30163((String)"HUD Element Config Screen");
    private static final List<HudElement> ELEMENTS = new ArrayList<HudElement>();
    @Nullable
    private final class_437 parent;
    @Nullable
    private HudElement selected = null;

    public HudElementConfigScreen(@Nullable class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    protected static void register(HudElement element) {
        ELEMENTS.add(Objects.requireNonNull(element, "Cannot register a null HUD Element"));
    }

    public static ButtonOption createOption() {
        return ButtonOption.createBuilder().name((class_2561)class_2561.method_43470((String)"HUD Manager")).prompt((class_2561)class_2561.method_43470((String)"Open")).action(screen -> class_310.method_1551().method_1507((class_437)new HudElementConfigScreen((class_437)screen))).build();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderTips(context);
        this.renderElements(context);
    }

    private void renderTips(class_332 context) {
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Left click to select an element", this.field_22789 >> 1, 9 * 2, -6250336);
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Right click to unselect an element", this.field_22789 >> 1, 9 * 3 + 4, -6250336);
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Press +/- to scale an element", this.field_22789 >> 1, 9 * 4 + 8, -6250336);
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Press R to reset an element's position/scale", this.field_22789 >> 1, 9 * 5 + 12, -6250336);
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Press TAB to cycle between elements", this.field_22789 >> 1, 9 * 6 + 16, -6250336);
    }

    private void renderElements(class_332 context) {
        for (HudElement element : ELEMENTS) {
            element.renderScreen(context);
        }
        if (this.selected != null) {
            int x = this.selected.x();
            int y = this.selected.y();
            int width = this.selected.width();
            int height = this.selected.height();
            context.method_51738(Math.max(x - 1, 0), Math.min(x + width + 1, this.field_22789), Math.max(y - 1, 0), -65536);
            context.method_51738(Math.max(x - 1, 0), Math.min(x + width + 1, this.field_22789), Math.min(y + height + 1, this.field_22790), -65536);
            context.method_51742(Math.max(x - 1, 0), Math.max(y - 1, 0), Math.min(y + height + 1, this.field_22790), -65536);
            context.method_51742(Math.min(x + width + 1, this.field_22789), Math.max(y - 1, 0), Math.min(y + height + 1, this.field_22790), -65536);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        switch (click.method_74245()) {
            case 0: {
                for (HudElement element : ELEMENTS) {
                    if (!RenderHelper.pointIsInArea(click.comp_4798(), click.comp_4799(), element.x(), element.y(), element.x() + element.width(), element.y() + element.height()) || this.selected == element) continue;
                    this.selected = element;
                    return true;
                }
                break;
            }
            case 1: {
                this.selected = null;
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.selected != null && click.method_74245() == 0) {
            this.selected.x((int)Math.clamp(click.comp_4798() - (double)(this.selected.width() >> 1), 0.0, (double)(this.field_22789 - this.selected.width())));
            this.selected.y((int)Math.clamp(click.comp_4799() - (double)(this.selected.height() >> 1), 0.0, (double)(this.field_22790 - this.selected.height())));
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25404(class_11908 input) {
        switch (input.comp_4795()) {
            case 61: {
                if (this.selected == null) break;
                this.selected.scale(this.selected.scale() + 0.1f);
                return true;
            }
            case 45: {
                if (this.selected == null || input.method_74239()) break;
                this.selected.scale(this.selected.scale() - 0.1f);
                return true;
            }
            case 82: {
                if (this.selected == null) break;
                this.selected.reset();
                return true;
            }
            case 258: {
                if (ELEMENTS.isEmpty()) break;
                if (this.selected == null) {
                    this.selected = ELEMENTS.getFirst();
                } else {
                    int index = ELEMENTS.indexOf(this.selected);
                    int nextIndex = (index + 1) % ELEMENTS.size();
                    this.selected = ELEMENTS.get(nextIndex);
                }
                return true;
            }
        }
        return super.method_25404(input);
    }

    public void method_25419() {
        for (HudElement element : ELEMENTS) {
            element.apply();
        }
        AaronModConfigManager.save();
        this.field_22787.method_1507(this.parent);
    }
}

