/*
 * Decompiled with CFR 0.152.
 */
package net.azureaaron.mod.utils.render.primitive;

import java.util.ArrayList;
import java.util.List;
import net.azureaaron.mod.utils.render.FrustumUtils;
import net.azureaaron.mod.utils.render.primitive.FilledBoxRenderer;
import net.azureaaron.mod.utils.render.primitive.OutlinedBoxRenderer;
import net.azureaaron.mod.utils.render.primitive.PrimitiveCollector;
import net.azureaaron.mod.utils.render.primitive.TextPrimitiveRenderer;
import net.azureaaron.mod.utils.render.state.FilledBoxRenderState;
import net.azureaaron.mod.utils.render.state.OutlinedBoxRenderState;
import net.azureaaron.mod.utils.render.state.TextRenderState;
import net.minecraft.class_11658;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4604;
import net.minecraft.class_5481;

public final class PrimitiveCollectorImpl
implements PrimitiveCollector {
    private static final class_310 CLIENT = class_310.method_1551();
    protected static final int MAX_OVERWORLD_BUILD_HEIGHT = 319;
    private final class_11658 worldState;
    private final class_4604 frustum;
    private List<FilledBoxRenderState> filledBoxStates = null;
    private List<OutlinedBoxRenderState> outlinedBoxStates = null;
    private List<TextRenderState> textStates = null;
    private boolean frozen = false;

    public PrimitiveCollectorImpl(class_11658 worldState, class_4604 frustum) {
        this.worldState = worldState;
        this.frustum = frustum;
    }

    @Override
    public void submitFilledBox(class_2338 pos, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.method_10263(), pos.method_10264(), pos.method_10260(), pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_243 pos, class_243 dimensions, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(pos.field_1352, pos.field_1351, pos.field_1350, pos.field_1352 + dimensions.field_1352, pos.field_1351 + dimensions.field_1351, pos.field_1350 + dimensions.field_1350, colourComponents, alpha, throughWalls);
    }

    @Override
    public void submitFilledBox(class_238 box, float[] colourComponents, float alpha, boolean throughWalls) {
        this.submitFilledBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, throughWalls);
    }

    private void submitFilledBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.filledBoxStates == null) {
            this.filledBoxStates = new ArrayList<FilledBoxRenderState>();
        }
        FilledBoxRenderState state = new FilledBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.throughWalls = throughWalls;
        this.filledBoxStates.add(state);
    }

    @Override
    public void submitOutlinedBox(class_238 box, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.submitOutlinedBox(box.field_1323, box.field_1322, box.field_1321, box.field_1320, box.field_1325, box.field_1324, colourComponents, alpha, lineWidth, throughWalls);
    }

    private void submitOutlinedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float[] colourComponents, float alpha, float lineWidth, boolean throughWalls) {
        this.ensureNotFrozen();
        if (!FrustumUtils.isVisible(this.frustum, minX, minY, minZ, maxX, maxY, maxZ)) {
            return;
        }
        if (this.outlinedBoxStates == null) {
            this.outlinedBoxStates = new ArrayList<OutlinedBoxRenderState>();
        }
        OutlinedBoxRenderState state = new OutlinedBoxRenderState();
        state.minX = minX;
        state.minY = minY;
        state.minZ = minZ;
        state.maxX = maxX;
        state.maxY = maxY;
        state.maxZ = maxZ;
        state.colourComponents = colourComponents;
        state.alpha = alpha;
        state.lineWidth = lineWidth;
        state.throughWalls = throughWalls;
        this.outlinedBoxStates.add(state);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, boolean throughWalls) {
        this.submitText(text, pos, 1.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, float scale, boolean throughWalls) {
        this.submitText(text, pos, scale, 0.0f, throughWalls);
    }

    @Override
    public void submitText(class_2561 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        this.submitText(text.method_30937(), pos, scale, yOffset, throughWalls);
    }

    private void submitText(class_5481 text, class_243 pos, float scale, float yOffset, boolean throughWalls) {
        this.ensureNotFrozen();
        if (this.textStates == null) {
            this.textStates = new ArrayList<TextRenderState>();
        }
        class_327 textRenderer = PrimitiveCollectorImpl.CLIENT.field_1772;
        float xOffset = (float)(-textRenderer.method_30880(text)) / 2.0f;
        class_327.class_11465 glyphs = textRenderer.method_71795(text, xOffset, yOffset, -1, false, 0);
        TextRenderState state = new TextRenderState();
        state.glyphs = glyphs;
        state.pos = pos;
        state.scale = scale * 0.025f;
        state.yOffset = yOffset;
        state.throughWalls = throughWalls;
        this.textStates.add(state);
    }

    public void endCollection() {
        this.frozen = true;
    }

    private void ensureNotFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot submit primitives once the collection phase has ended!");
        }
    }

    public void dispatchPrimitivesToRenderers(class_12075 cameraState) {
        if (!this.frozen) {
            throw new IllegalStateException("Cannot dispatch primitives until the collection phase has ended!");
        }
        if (this.filledBoxStates != null) {
            for (FilledBoxRenderState filledBoxRenderState : this.filledBoxStates) {
                FilledBoxRenderer.INSTANCE.submitPrimitives(filledBoxRenderState, cameraState);
            }
        }
        if (this.outlinedBoxStates != null) {
            for (OutlinedBoxRenderState outlinedBoxRenderState : this.outlinedBoxStates) {
                OutlinedBoxRenderer.INSTANCE.submitPrimitives(outlinedBoxRenderState, cameraState);
            }
        }
        if (this.textStates != null) {
            for (TextRenderState textRenderState : this.textStates) {
                TextPrimitiveRenderer.INSTANCE.submitPrimitives(textRenderState, cameraState);
            }
        }
    }
}

