/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_3341;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import telepathicgrunt.structure_layout_optimizer.services.PlatformService;

public class StructureTemplateOptimizer {
    private static final Map<class_3491, Boolean> FINALIZE_PROCESSING_PROCESSORS = Object2BooleanMaps.synchronize((Object2BooleanMap)new Object2BooleanOpenHashMap());
    private static final String FINALIZE_PROCESSING_METHOD_NAME = PlatformService.INSTANCE.getFinalizeProcessingMethodName();

    @NotNull
    public static List<class_3499.class_3501> getStructureBlockInfosInBounds(class_3499.class_5162 palette, class_2338 offset, class_3492 structurePlaceSettings) {
        class_3341 boundingBox = structurePlaceSettings.method_15124();
        List originalPositions = palette.method_27125();
        if (boundingBox == null) {
            return originalPositions;
        }
        for (class_3491 processor : structurePlaceSettings.method_16182()) {
            if (!FINALIZE_PROCESSING_PROCESSORS.computeIfAbsent(processor, StructureTemplateOptimizer::isFinalizeProcessor).booleanValue()) continue;
            return palette.method_27125();
        }
        class_2415 mirror = structurePlaceSettings.method_15114();
        class_2470 rotation = structurePlaceSettings.method_15113();
        class_2338 pivot = structurePlaceSettings.method_15134();
        ArrayList<class_3499.class_3501> listOfInBoundsRelativePositions = new ArrayList<class_3499.class_3501>();
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (class_3499.class_3501 blockInfo : palette.method_27125()) {
            mutableBlockPos.method_10101((class_2382)blockInfo.comp_1341());
            StructureTemplateOptimizer.transform(mutableBlockPos, mirror, rotation, pivot);
            mutableBlockPos.method_30927((class_2382)offset);
            if (!boundingBox.method_14662((class_2382)mutableBlockPos)) continue;
            listOfInBoundsRelativePositions.add(blockInfo);
        }
        if (listOfInBoundsRelativePositions.isEmpty() && !originalPositions.isEmpty()) {
            listOfInBoundsRelativePositions.add((class_3499.class_3501)originalPositions.get(0));
        }
        return listOfInBoundsRelativePositions;
    }

    @NotNull
    private static Boolean isFinalizeProcessor(class_3491 structureProcessor) {
        try {
            Method method = structureProcessor.getClass().getMethod(FINALIZE_PROCESSING_METHOD_NAME, class_5425.class, class_2338.class, class_2338.class, List.class, List.class, class_3492.class);
            return method.getDeclaringClass() != class_3491.class;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to find 'finalizeProcessing' method. Report this major issue to Dev of structure_layout_optimizer", e);
        }
    }

    private static void transform(class_2338.class_2339 mutableBlockPos, class_2415 mirror, class_2470 rotation, class_2338 pivot) {
        int i = mutableBlockPos.method_10263();
        int j = mutableBlockPos.method_10264();
        int k = mutableBlockPos.method_10260();
        boolean flag = true;
        switch (mirror) {
            case field_11300: {
                k = -k;
                break;
            }
            case field_11301: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        int l = pivot.method_10263();
        int i1 = pivot.method_10260();
        switch (rotation) {
            case field_11465: {
                mutableBlockPos.method_10103(l - i1 + k, j, l + i1 - i);
                return;
            }
            case field_11463: {
                mutableBlockPos.method_10103(l + i1 - k, j, i1 - l + i);
                return;
            }
            case field_11464: {
                mutableBlockPos.method_10103(l + l - i, j, i1 + i1 - k);
                return;
            }
        }
        if (flag) {
            mutableBlockPos.method_10103(i, j, k);
        }
    }
}

