/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_5000;
import net.minecraft.class_5819;

public final class GeneralUtils {
    private GeneralUtils() {
    }

    public static <T> T loadService(Class<T> service) {
        return ServiceLoader.load(service, service.getClassLoader()).findFirst().orElseThrow(() -> new IllegalStateException("No platform implementation found for " + service.getName()));
    }

    public static boolean canJigsawsAttach(class_3499.class_10326 jigsaw1, class_3499.class_10326 jigsaw2) {
        class_5000 prop1 = (class_5000)jigsaw1.comp_3278().comp_1342().method_11654((class_2769)class_3748.field_23262);
        class_5000 prop2 = (class_5000)jigsaw2.comp_3278().comp_1342().method_11654((class_2769)class_3748.field_23262);
        return prop1.method_26426() == prop2.method_26426().method_10153() && (prop1.method_26428() == prop2.method_26428() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && GeneralUtils.getStringMicroOptimised(jigsaw1.comp_3278().comp_1343(), "target").equals(GeneralUtils.getStringMicroOptimised(jigsaw2.comp_3278().comp_1343(), "name"));
    }

    private static boolean isRollableJoint(class_3499.class_10326 jigsaw1, class_5000 prop1) {
        String joint = GeneralUtils.getStringMicroOptimised(jigsaw1.comp_3278().comp_1343(), "joint");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.method_26426().method_10166().method_10179();
        }
        return joint.equals("rollable");
    }

    public static void shuffleAndPrioritize(List<class_3499.class_10326> list, class_5819 random) {
        Int2ObjectArrayMap buckets = new Int2ObjectArrayMap();
        for (class_3499.class_10326 structureBlockInfo : list) {
            int key = 0;
            if (structureBlockInfo.comp_3278().comp_1343() != null) {
                key = GeneralUtils.getIntMicroOptimised(structureBlockInfo.comp_3278().comp_1343(), "selection_priority");
            }
            ((List)buckets.computeIfAbsent(key, k -> new ArrayList())).add(structureBlockInfo);
        }
        for (List bucketList : buckets.values()) {
            class_156.method_43028((List)bucketList, (class_5819)random);
        }
        if (buckets.size() == 1) {
            list.clear();
            GeneralUtils.copyAll((List)((Int2ObjectMap.Entry)buckets.int2ObjectEntrySet().fastIterator().next()).getValue(), list);
        } else if (buckets.size() > 1) {
            list.clear();
            IntArrayList keys = new IntArrayList((IntCollection)buckets.keySet());
            keys.sort(IntComparators.OPPOSITE_COMPARATOR);
            for (int i = 0; i < keys.size(); ++i) {
                GeneralUtils.copyAll((List)buckets.get(keys.getInt(i)), list);
            }
        }
    }

    public static int getIntMicroOptimised(class_2487 tag, String key) {
        int n;
        class_2520 class_25202 = tag.method_10580(key);
        if (class_25202 instanceof class_2514) {
            class_2514 numericTag = (class_2514)class_25202;
            n = numericTag.method_10701();
        } else {
            n = 0;
        }
        return n;
    }

    public static String getStringMicroOptimised(class_2487 tag, String key) {
        String string;
        class_2520 class_25202 = tag.method_10580(key);
        if (class_25202 instanceof class_2519) {
            class_2519 stringTag = (class_2519)class_25202;
            string = stringTag.method_10714();
        } else {
            string = "";
        }
        return string;
    }

    public static <T> void copyAll(List<T> src, List<T> dest) {
        for (int i = 0; i < src.size(); ++i) {
            dest.add(src.get(i));
        }
    }
}

