/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import java.util.Iterator;
import net.minecraft.class_2338;
import net.minecraft.class_3499;
import telepathicgrunt.structure_layout_optimizer.utils.PalettedStructureBlockInfoList;

public class PalettedStructureBlockInfoListIterator
implements Iterator<class_3499.class_3501> {
    private final PalettedStructureBlockInfoList infos;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;
    private final int stateOffset;
    private final int xMask;
    private final int yMask;
    private final int zMask;
    private final int stateMask;
    private final int tagMask;
    private int index = 0;

    public PalettedStructureBlockInfoListIterator(PalettedStructureBlockInfoList infos) {
        this.infos = infos;
        this.xOffset = infos.xBits;
        this.yOffset = this.xOffset + infos.yBits;
        this.zOffset = this.yOffset + infos.zBits;
        this.stateOffset = this.zOffset + infos.stateBits;
        this.xMask = (1 << infos.xBits) - 1;
        this.yMask = (1 << infos.yBits) - 1;
        this.zMask = (1 << infos.zBits) - 1;
        this.stateMask = (1 << infos.stateBits) - 1;
        this.tagMask = (1 << infos.nbtBits) - 1;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.size();
    }

    @Override
    public class_3499.class_3501 next() {
        int index;
        if ((index = this.toIndex(this.index++)) >= this.infos.size) {
            throw new IndexOutOfBoundsException();
        }
        int bitsPerEntry = this.infos.bitsPerEntry;
        if (bitsPerEntry == 0) {
            return new class_3499.class_3501(new class_2338(0, 0, 0), this.infos.states[0], this.infos.nbts[0]);
        }
        int entriesPerLong = 64 / bitsPerEntry;
        long entry = this.infos.data[index / entriesPerLong] >>> index % entriesPerLong * bitsPerEntry;
        int x = (int)(entry & (long)this.xMask);
        int y = (int)(entry >> this.xOffset & (long)this.yMask);
        int z = (int)(entry >> this.yOffset & (long)this.zMask);
        int state = (int)(entry >> this.zOffset & (long)this.stateMask);
        int tag = (int)(entry >> this.stateOffset & (long)this.tagMask);
        return new class_3499.class_3501(new class_2338(x, y, z), this.infos.states[state], this.infos.nbts[tag]);
    }

    protected int toIndex(int index) {
        return index;
    }

    protected int size() {
        return this.infos.size;
    }
}

