/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.block;

import com.lithiumcraft.createresourcegeodes.block.entity.CatalystBlock;
import com.lithiumcraft.createresourcegeodes.config.CatalystShape;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.registry.ModRegistries;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class GenericCatalystBlock
extends CatalystBlock
implements CatalystDataProvider {
    public GenericCatalystBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public ResourceLocation getCatalystId() {
        return BuiltInRegistries.BLOCK.getKey((Object)this);
    }

    @Override
    public Block getDefaultGeneratorBlock() {
        return Blocks.INFESTED_DEEPSLATE;
    }

    @Override
    public CatalystShape getDefaultShape() {
        return CatalystShape.SPHERE;
    }

    @Override
    public int getDefaultCooldown() {
        return 120;
    }

    @Override
    public float getFillPercentage(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.fillPercentage() : 1.0f;
    }
}

