/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.block.entity;

import com.lithiumcraft.createresourcegeodes.block.entity.CatalystBlockEntity;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.item.custom.ActivatorWandItem;
import com.lithiumcraft.createresourcegeodes.item.custom.BaseCatalystAgitatorItem;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.ModList;

public abstract class CatalystBlock
extends Block
implements EntityBlock,
CatalystDataProvider {
    private static final boolean MEKANISM_LOADED = ModList.get().isLoaded("mekanism");
    private static final boolean JDT_LOADED = ModList.get().isLoaded("justdirethings");

    public CatalystBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CatalystBlockEntity(pos, state);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof CatalystBlockEntity) {
            CatalystBlockEntity catalystBE = (CatalystBlockEntity)be;
            ResourceLocation id = this.getCatalystId();
            catalystBE.setCatalystId(id, (ServerLevel)level);
            catalystBE.setChanged();
            level.sendBlockUpdated(pos, state, state, 3);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean success;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CatalystBlockEntity)) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        CatalystBlockEntity catalyst = (CatalystBlockEntity)blockEntity;
        if (stack.getItem() instanceof ActivatorWandItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof BaseCatalystAgitatorItem) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        CatalystGeneratorDefinition def = catalyst.getGeneratorDefinition();
        if (def == null || def.customAgitatorItem() == null) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.is(def.customAgitatorItem())) {
            return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
        }
        if (catalyst.isOnCooldown()) {
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.NOTE_BLOCK_BASS, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                server.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 8, 0.2, 0.2, 0.2, 0.01);
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (player != null && !player.isCreative()) {
            stack.shrink(1);
        }
        return (success = catalyst.tryActivate(level, stack, player)) ? ItemInteractionResult.SUCCESS : ItemInteractionResult.FAIL;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        if (!level.isClientSide && (be = level.getBlockEntity(pos)) instanceof CatalystBlockEntity) {
            CatalystBlockEntity catalyst = (CatalystBlockEntity)be;
            CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            if (data != null) {
                CompoundTag tag = data.copyTag();
                catalyst.loadCustomData(tag, (HolderLookup.Provider)level.registryAccess());
            } else if (placer instanceof Player) {
                catalyst.setUserPlaced(true);
            }
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    private boolean isUserPlaced(LevelReader level, BlockPos pos) {
        CatalystBlockEntity catalyst;
        BlockEntity be = level.getBlockEntity(pos);
        return be instanceof CatalystBlockEntity && (catalyst = (CatalystBlockEntity)be).isUserPlaced();
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 15, 0.0, 0.0, 0.0, 0.2);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (be instanceof CatalystBlockEntity) {
                CatalystBlockEntity catalystBE = (CatalystBlockEntity)be;
                catalystBE.tickServer((ServerLevel)lvl, pos, st);
            }
        };
    }
}

