/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.block.entity;

import com.lithiumcraft.createresourcegeodes.block.entity.ModBlockEntities;
import com.lithiumcraft.createresourcegeodes.config.CatalystShape;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.network.ClientboundSyncCatalystDataPacket;
import com.lithiumcraft.createresourcegeodes.network.ModNetwork;
import com.lithiumcraft.createresourcegeodes.registry.CatalystRegistryCache;
import com.lithiumcraft.createresourcegeodes.registry.ModRegistries;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import com.lithiumcraft.createresourcegeodes.util.CatalystShapeTasks;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CatalystBlockEntity
extends BlockEntity
implements CatalystDataProvider {
    private ResourceLocation catalystId;
    private int currentCooldown = -1;
    private int cachedTier = -1;
    private int cooldownTicksRemaining = 0;
    public int clientSyncedCooldown = 0;
    public int clientSyncedTier = 0;
    public Optional<ResourceLocation> clientSyncedAgitatorItem = Optional.empty();
    private boolean userPlaced = false;

    public CatalystBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CATALYST.get(), pos, state);
    }

    public void setUserPlaced(boolean userPlaced) {
        this.userPlaced = userPlaced;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isUserPlaced() {
        return this.userPlaced;
    }

    public void setCatalystId(ResourceLocation id, ServerLevel level) {
        this.catalystId = id;
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(id);
        if (def != null) {
            this.currentCooldown = def.cooldownTicks();
            this.cachedTier = def.minimumTier();
        } else {
            this.currentCooldown = this.getDefaultCooldown();
            this.cachedTier = this.getDefaultMinimumTier();
        }
        this.setChanged();
        Optional<ResourceLocation> agitatorItem = Optional.empty();
        if (def != null && def.customAgitatorItem() != null) {
            agitatorItem = Optional.of(BuiltInRegistries.ITEM.getKey((Object)def.customAgitatorItem()));
        }
        ModNetwork.sendCatalystSync(new ClientboundSyncCatalystDataPacket(this.worldPosition, this.cooldownTicksRemaining, this.cachedTier, agitatorItem), level, this.worldPosition);
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @Override
    public ResourceLocation getCatalystId() {
        return this.catalystId;
    }

    @Override
    public Block getDefaultGeneratorBlock() {
        return Blocks.INFESTED_DEEPSLATE;
    }

    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        if (this.catalystId == null) {
            ResourceLocation id;
            Block block = level.getBlockState(this.worldPosition).getBlock();
            if (block instanceof CatalystDataProvider) {
                CatalystDataProvider provider = (CatalystDataProvider)block;
                v0 = provider.getCatalystId();
            } else {
                v0 = id = null;
            }
            if (id != null) {
                this.ensureCachedTier();
                this.setCatalystId(id, level);
                level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
        if (this.cooldownTicksRemaining > 0) {
            --this.cooldownTicksRemaining;
            this.setChanged();
            if (this.cooldownTicksRemaining % 20 == 0) {
                CatalystGeneratorDefinition def = this.getGeneratorDefinition();
                Optional<ResourceLocation> agitatorItem = Optional.empty();
                if (def != null && def.customAgitatorItem() != null) {
                    agitatorItem = Optional.of(BuiltInRegistries.ITEM.getKey((Object)def.customAgitatorItem()));
                }
                ModNetwork.sendCatalystSync(new ClientboundSyncCatalystDataPacket(this.worldPosition, this.cooldownTicksRemaining, this.cachedTier, agitatorItem), level, this.worldPosition);
                level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public void resetCooldown() {
        this.cooldownTicksRemaining = this.currentCooldown;
        this.setChanged();
    }

    public CompoundTag saveCustomData(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, provider);
        if (!tag.contains("id")) {
            tag.putString("id", BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)this.getType()).toString());
        }
        return tag;
    }

    public void loadCustomData(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadAdditional(tag, provider);
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.catalystId != null) {
            tag.putString("CatalystId", this.catalystId.toString());
        }
        tag.putInt("CachedCooldown", this.currentCooldown);
        tag.putInt("CachedTier", this.cachedTier);
        tag.putInt("RemainingCooldown", this.cooldownTicksRemaining);
        tag.putBoolean("UserPlaced", this.userPlaced);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("CatalystId")) {
            this.catalystId = ResourceLocation.parse((String)tag.getString("CatalystId"));
        }
        this.currentCooldown = tag.getInt("CachedCooldown");
        this.cachedTier = tag.getInt("CachedTier");
        this.cooldownTicksRemaining = tag.getInt("RemainingCooldown");
        this.userPlaced = tag.getBoolean("UserPlaced");
    }

    public void onLoad() {
        Level level;
        super.onLoad();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.getBlockState().getBlock();
            if (block instanceof CatalystDataProvider) {
                CatalystDataProvider provider = (CatalystDataProvider)block;
                this.cachedTier = provider.getMinimumTier(serverLevel);
                this.currentCooldown = provider.getCooldown(serverLevel);
            }
            CatalystGeneratorDefinition def = this.getGeneratorDefinition();
            Optional<ResourceLocation> agitatorItem = Optional.empty();
            if (def != null && def.customAgitatorItem() != null) {
                agitatorItem = Optional.of(BuiltInRegistries.ITEM.getKey((Object)def.customAgitatorItem()));
            }
            ModNetwork.sendCatalystSync(new ClientboundSyncCatalystDataPacket(this.worldPosition, this.cooldownTicksRemaining, this.cachedTier, agitatorItem), serverLevel, this.worldPosition);
            this.setChanged();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private void ensureCachedTier() {
        Level level;
        if (this.cachedTier < 0 && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.getBlockState().getBlock();
            if (block instanceof CatalystDataProvider) {
                CatalystDataProvider provider = (CatalystDataProvider)block;
                this.cachedTier = provider.getMinimumTier(serverLevel);
            }
        }
    }

    public boolean tryActivate(Level level, ItemStack usedStack, @Nullable Player player) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.cooldownTicksRemaining > 0) {
            BlockPos pos = this.getBlockPos();
            server.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.NOTE_BLOCK_BASS, SoundSource.BLOCKS, 1.0f, 1.0f);
            server.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + 1.2, (double)this.getBlockPos().getZ() + 0.5, 8, 0.2, 0.2, 0.2, 0.01);
            return false;
        }
        CatalystGeneratorDefinition def = this.getGeneratorDefinition();
        if (def == null) {
            return false;
        }
        Block generator = def.generatorBlock();
        CatalystShape shape = def.shape();
        int radius = def.radius();
        float fill = def.fillPercentage();
        switch (shape) {
            case SPHERE: {
                CatalystShapeTasks.queueSphere(level, this.getBlockPos(), generator, radius, fill);
                break;
            }
            case CUBE: {
                CatalystShapeTasks.queueCube(level, this.getBlockPos(), generator, radius, fill);
            }
        }
        this.cooldownTicksRemaining = this.currentCooldown;
        if (player != null && !player.isCreative()) {
            usedStack.hurtAndBreak(1, (LivingEntity)player, null);
        }
        return true;
    }

    public boolean isOnCooldown() {
        return this.cooldownTicksRemaining > 0;
    }

    public CatalystGeneratorDefinition getGeneratorDefinition() {
        Block block;
        if (this.catalystId == null) {
            return null;
        }
        CatalystGeneratorDefinition def = this.level.isClientSide ? CatalystRegistryCache.BY_ID.get(this.catalystId) : (CatalystGeneratorDefinition)this.level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY).get(this.catalystId);
        if (def == null && (block = this.getBlockState().getBlock()) instanceof CatalystDataProvider) {
            CatalystDataProvider provider = (CatalystDataProvider)block;
            return new CatalystGeneratorDefinition(provider.getDefaultGeneratorBlock(), provider.getDefaultCooldown(), provider.getDefaultShape(), provider.getDefaultRadius(), provider.getDefaultFillPercentage(), provider.getDefaultMinimumTier(), null);
        }
        return def;
    }
}

