/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.compat.jade;

import com.lithiumcraft.createresourcegeodes.block.entity.CatalystBlockEntity;
import com.lithiumcraft.createresourcegeodes.item.custom.BaseCatalystAgitatorItem;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

class CatalystTooltipProvider
implements IBlockComponentProvider {
    public static final CatalystTooltipProvider INSTANCE = new CatalystTooltipProvider();

    CatalystTooltipProvider() {
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockEntity be = accessor.getBlockEntity();
        if (!(be instanceof CatalystBlockEntity)) {
            return;
        }
        CatalystBlockEntity catalystBE = (CatalystBlockEntity)be;
        int cooldown = catalystBE.clientSyncedCooldown;
        if (cooldown <= 0) {
            tooltip.add((Component)Component.literal((String)"Ready to be Agitated!").withStyle(ChatFormatting.GREEN));
        } else {
            int seconds = cooldown / 20;
            tooltip.add((Component)Component.literal((String)("Ready in " + seconds + " seconds")).withStyle(ChatFormatting.YELLOW));
        }
        Optional<ResourceLocation> customItemOpt = catalystBE.clientSyncedAgitatorItem;
        Player player = accessor.getPlayer();
        boolean showRequirement = true;
        if (customItemOpt != null && customItemOpt.isPresent()) {
            ItemStack held;
            ResourceLocation heldItemId;
            ResourceLocation customItem = customItemOpt.get();
            if (player != null && (heldItemId = BuiltInRegistries.ITEM.getKey((Object)(held = player.getMainHandItem()).getItem())).equals((Object)customItem)) {
                showRequirement = false;
            }
            if (showRequirement) {
                Item item = (Item)BuiltInRegistries.ITEM.get(customItem);
                tooltip.add((Component)Component.literal((String)"Requires: ").append((Component)Component.translatable((String)item.getDescriptionId())).withStyle(ChatFormatting.DARK_RED));
            }
        } else {
            BaseCatalystAgitatorItem agitator;
            ItemStack heldItem;
            Item item;
            Block heldItemId;
            int tier = catalystBE.clientSyncedTier;
            if (tier <= 0 && (heldItemId = accessor.getBlockState().getBlock()) instanceof CatalystDataProvider) {
                CatalystDataProvider provider = (CatalystDataProvider)heldItemId;
                tier = accessor.getLevel().isClientSide() ? provider.getDefaultMinimumTier() : provider.getMinimumTier((ServerLevel)accessor.getLevel());
            }
            if (player != null && (item = (heldItem = player.getMainHandItem()).getItem()) instanceof BaseCatalystAgitatorItem && (agitator = (BaseCatalystAgitatorItem)item).getTier().getLevel() >= tier) {
                showRequirement = false;
            }
            if (showRequirement) {
                tooltip.add((Component)Component.literal((String)("Requires Tier: " + tier)).withStyle(ChatFormatting.DARK_RED));
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"createresourcegeodes", (String)"catalyst_tooltip");
    }
}

