/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.compat.jei;

import com.lithiumcraft.createresourcegeodes.config.CatalystShape;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.item.ModItems;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CatalystRecipe {
    private final ItemStack catalystItem;
    private final Block generatorBlock;
    private final CatalystGeneratorDefinition definition;

    public CatalystRecipe(ItemStack catalystItem, CatalystGeneratorDefinition def) {
        this.catalystItem = catalystItem.copy();
        this.generatorBlock = def.generatorBlock();
        this.definition = def;
    }

    public CatalystGeneratorDefinition getDefinition() {
        return this.definition;
    }

    public int getTier() {
        return this.definition.minimumTier();
    }

    public int getCooldownTicks() {
        return this.definition.cooldownTicks();
    }

    public CatalystShape getShape() {
        return this.definition.shape();
    }

    public int getRadius() {
        return this.definition.radius();
    }

    public float getFillPercentage() {
        return this.definition.fillPercentage();
    }

    public ItemStack getCatalystItem() {
        return this.catalystItem;
    }

    public ItemStack getAgitatorItem() {
        if (this.definition.isCustomAgitatorBased()) {
            return new ItemStack((ItemLike)this.definition.customAgitatorItem());
        }
        return switch (this.definition.minimumTier()) {
            case 2 -> new ItemStack((ItemLike)ModItems.CATALYST_AGITATOR_TIER_2.get());
            case 3 -> new ItemStack((ItemLike)ModItems.CATALYST_AGITATOR_TIER_3.get());
            case 4 -> new ItemStack((ItemLike)ModItems.CATALYST_AGITATOR_TIER_4.get());
            default -> new ItemStack((ItemLike)ModItems.CATALYST_AGITATOR.get());
        };
    }
}

