/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.compat.jei;

import com.lithiumcraft.createresourcegeodes.block.ModBlocks;
import com.lithiumcraft.createresourcegeodes.compat.jei.CatalystRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CatalystRecipeCategory
implements IRecipeCategory<CatalystRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"createresourcegeodes", (String)"catalyst_generation");
    public static final RecipeType<CatalystRecipe> TYPE = RecipeType.create((String)"createresourcegeodes", (String)"catalyst_generation", CatalystRecipe.class);
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/anvil.png");
    private static final int WIDTH = 150;
    private static final int HEIGHT = 65;
    private final IDrawable icon;
    private final IDrawable background;

    public CatalystRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.SKY_STONE_CATALYST.asItem()));
        this.background = guiHelper.createDrawable(TEXTURE, 14, 38, 140, 36);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public int getWidth() {
        return 150;
    }

    public int getHeight() {
        return 65;
    }

    public RecipeType<CatalystRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"jei.createresourcegeodes.category.catalyst_generation");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CatalystRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 9).addItemStack(recipe.getAgitatorItem());
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 9).addItemStack(recipe.getCatalystItem());
        Block generatorBlock = recipe.getDefinition().generatorBlock();
        Item blockItem = generatorBlock.asItem();
        if (blockItem == Items.AIR || blockItem == null) {
            blockItem = Items.BARRIER;
        }
        ItemStack displayStack = new ItemStack((ItemLike)blockItem);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 120, 9).addItemStack(displayStack);
    }

    public void draw(CatalystRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        String text;
        Minecraft mc = Minecraft.getInstance();
        Font font = mc.font;
        if (recipe.getDefinition().isCustomAgitatorBased()) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)recipe.getDefinition().customAgitatorItem());
            Object itemName = id.getPath().replace("_", " ");
            itemName = ((String)itemName).substring(0, 1).toUpperCase() + ((String)itemName).substring(1);
            text = "Requires: " + (String)itemName;
        } else {
            text = "Tier " + recipe.getDefinition().minimumTier() + " Agitator Required";
        }
        int x = 11;
        int y = 57;
        guiGraphics.drawString(font, text, x, y, 8453920, false);
    }
}

