/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.compat.jei;

import com.lithiumcraft.createresourcegeodes.block.ModBlocks;
import com.lithiumcraft.createresourcegeodes.compat.jei.CatalystRecipe;
import com.lithiumcraft.createresourcegeodes.compat.jei.CatalystRecipeCategory;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.registry.CatalystRegistryCache;
import com.lithiumcraft.createresourcegeodes.registry.ModRegistries;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class CreateResourceGeodesJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"createresourcegeodes", (String)"jei_plugin");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CatalystRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel level;
        if (CatalystRegistryCache.BY_ID.isEmpty() && (level = Minecraft.getInstance().level) != null) {
            try {
                RegistryAccess.Frozen access = Minecraft.getInstance().player.connection.registryAccess();
                Registry registry = access.registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
                CatalystRegistryCache.updateFromRegistry((Registry<CatalystGeneratorDefinition>)registry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        List<CatalystRecipe> recipes = ModBlocks.BLOCKS.getEntries().stream().map(Supplier::get).filter(block -> block instanceof CatalystDataProvider).map(block -> {
            Item blockItem;
            CatalystDataProvider provider = (CatalystDataProvider)block;
            ResourceLocation id = provider.getCatalystId();
            CatalystGeneratorDefinition def = CatalystRegistryCache.BY_ID.get(id);
            if (def == null) {
                def = new CatalystGeneratorDefinition(provider.getDefaultGeneratorBlock(), provider.getDefaultCooldown(), provider.getDefaultShape(), provider.getDefaultRadius(), provider.getDefaultFillPercentage(), provider.getDefaultMinimumTier(), null);
            }
            if ((blockItem = block.asItem()) == Items.AIR || blockItem == null) {
                return null;
            }
            Item genItem = def.generatorBlock().asItem();
            if (genItem == Items.AIR || genItem == null) {
                return null;
            }
            return new CatalystRecipe(new ItemStack((ItemLike)blockItem), def);
        }).filter(Objects::nonNull).toList();
        registration.addRecipes(CatalystRecipeCategory.TYPE, recipes);
        List<ItemStack> catalystItems = recipes.stream().map(CatalystRecipe::getCatalystItem).filter(stack -> !stack.isEmpty()).distinct().toList();
        if (!catalystItems.isEmpty()) {
            for (CatalystRecipe recipe : recipes) {
                ItemStack stack2 = recipe.getCatalystItem();
                Object shapeName = recipe.getDefinition().shape().name().toLowerCase();
                shapeName = ((String)shapeName).substring(0, 1).toUpperCase() + ((String)shapeName).substring(1);
                Object generatorName = BuiltInRegistries.BLOCK.getKey((Object)recipe.getDefinition().generatorBlock()).getPath();
                generatorName = ((String)generatorName).substring(0, 1).toUpperCase() + ((String)generatorName).substring(1);
                MutableComponent info = Component.literal((String)"").append((Component)Component.literal((String)"Generates: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)generatorName).withStyle(ChatFormatting.DARK_PURPLE));
                if (recipe.getDefinition().isCustomAgitatorBased()) {
                    ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)recipe.getDefinition().customAgitatorItem());
                    Object itemName = itemId.getPath().replace("_", " ");
                    itemName = ((String)itemName).substring(0, 1).toUpperCase() + ((String)itemName).substring(1);
                    info = info.append((Component)Component.literal((String)"\nAgitator Required: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)itemName).withStyle(ChatFormatting.DARK_PURPLE));
                } else {
                    info = info.append((Component)Component.literal((String)"\nTier Required: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)("Tier " + recipe.getDefinition().minimumTier())).withStyle(ChatFormatting.DARK_PURPLE));
                }
                info = info.append((Component)Component.literal((String)"\nCooldown: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)(recipe.getCooldownTicks() / 20 + " seconds")).withStyle(ChatFormatting.DARK_PURPLE)).append((Component)Component.literal((String)"\nRadius: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)("" + recipe.getRadius())).withStyle(ChatFormatting.DARK_PURPLE)).append((Component)Component.literal((String)"\nFill: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)(Math.round(recipe.getFillPercentage() * 100.0f) + "%")).withStyle(ChatFormatting.DARK_PURPLE)).append((Component)Component.literal((String)"\nShape: ").withStyle(ChatFormatting.DARK_GRAY)).append((Component)Component.literal((String)shapeName).withStyle(ChatFormatting.DARK_PURPLE));
                registration.addIngredientInfo(List.of(stack2), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{info});
            }
        }
    }
}

