/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.event;

import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.item.ModItems;
import com.lithiumcraft.createresourcegeodes.network.ClientboundCatalystRegistryPacket;
import com.lithiumcraft.createresourcegeodes.registry.CatalystRegistryCache;
import com.lithiumcraft.createresourcegeodes.registry.ModRegistries;
import com.lithiumcraft.createresourcegeodes.util.CatalystShapeTasks;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;

@EventBusSubscriber(modid="createresourcegeodes", bus=EventBusSubscriber.Bus.GAME)
public class ModEvents {
    @SubscribeEvent
    public static void addCustomWanderingTrades(WandererTradesEvent event) {
        List genericTrades = event.getGenericTrades();
        List rareTrades = event.getRareTrades();
        rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)ModItems.CATALYST_ACTIVATOR_WAND_GEM.get(), 1), 1, 10, 0.2f));
        rareTrades.add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)ModItems.CATALYST_ACTIVATOR_WAND_SHAFT.get(), 1), 1, 10, 0.2f));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server = event.getServer();
        CatalystShapeTasks.tick(server);
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        RegistryAccess.Frozen access = event.getServer().registryAccess();
        Registry registry = access.registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        Map<ResourceLocation, CatalystGeneratorDefinition> toSend = registry.entrySet().stream().collect(Collectors.toMap(e -> ((ResourceKey)e.getKey()).location(), Map.Entry::getValue));
        ClientboundCatalystRegistryPacket packet = new ClientboundCatalystRegistryPacket(toSend);
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            player.connection.send((CustomPacketPayload)packet);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        RegistryAccess.Frozen access = player2.server.registryAccess();
        Registry registry = access.registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        Map<ResourceLocation, CatalystGeneratorDefinition> toSend = registry.entrySet().stream().collect(Collectors.toMap(e -> ((ResourceKey)e.getKey()).location(), Map.Entry::getValue));
        player2.connection.send((CustomPacketPayload)new ClientboundCatalystRegistryPacket(toSend));
    }

    @SubscribeEvent
    public static void onClientDisconnect(ClientPlayerNetworkEvent.LoggingOut event) {
        CatalystRegistryCache.BY_ID.clear();
        CatalystRegistryCache.DEFINITIONS.clear();
    }
}

