/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.item.custom;

import com.lithiumcraft.createresourcegeodes.Config;
import com.lithiumcraft.createresourcegeodes.block.entity.CatalystBlockEntity;
import com.lithiumcraft.createresourcegeodes.config.WandMode;
import com.lithiumcraft.createresourcegeodes.sound.ModSounds;
import com.lithiumcraft.createresourcegeodes.util.CatalystDataProvider;
import com.lithiumcraft.createresourcegeodes.util.WandModeUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivatorWandItem
extends Item {
    public static final Random RAND = new Random();
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivatorWandItem.class);

    public ActivatorWandItem(Item.Properties properties) {
        super(new Item.Properties().stacksTo(1).durability(65).rarity(Rarity.RARE));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)("Mode: " + String.valueOf((Object)WandModeUtil.getMode(stack)))).withStyle(ChatFormatting.DARK_PURPLE));
    }

    public boolean isEnchantable(ItemStack stack) {
        return Config.catalystWandDurability;
    }

    public int getEnchantmentValue() {
        return Config.catalystWandDurability ? 15 : 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return Config.catalystWandDurability;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.NETHERITE_INGOT);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        stack.setDamageValue(stack.getDamageValue() + 1);
        if (stack.getDamageValue() >= stack.getMaxDamage()) {
            stack.setCount(0);
        }
        return stack.copy();
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        Block block = state.getBlock();
        if (!(block instanceof CatalystDataProvider)) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        WandMode mode = WandModeUtil.getMode(context.getItemInHand());
        if (mode == WandMode.MOVE) {
            return this.tryMoveCatalyst(context, level, pos, state);
        }
        if (mode == WandMode.BREAK) {
            return this.tryBreakCatalyst(context, level, pos, state);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!level.isClientSide) {
                WandMode currentMode = WandModeUtil.getMode(stack);
                WandMode nextMode = currentMode.next();
                WandModeUtil.setMode(stack, nextMode);
                player.displayClientMessage((Component)Component.literal((String)("Switched to " + nextMode.name() + " Mode")), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    private InteractionResult tryMoveCatalyst(UseOnContext context, Level level, BlockPos oldPos, BlockState oldState) {
        boolean validTarget;
        int x = oldPos.getX();
        int y = oldPos.getY();
        int z = oldPos.getZ();
        int offset = Config.moveCatalystDistance;
        switch (context.getClickedFace().getOpposite()) {
            case UP: {
                y += offset;
                break;
            }
            case DOWN: {
                y -= offset;
                break;
            }
            case EAST: {
                x += offset;
                break;
            }
            case WEST: {
                x -= offset;
                break;
            }
            case NORTH: {
                z -= offset;
                break;
            }
            case SOUTH: {
                z += offset;
            }
        }
        BlockPos newPos = new BlockPos(x, y, z);
        boolean bl = validTarget = Config.catalystMoveIgnoreWater && level.getBlockState(newPos).is(Blocks.WATER) || level.getBlockState(newPos).isAir();
        if (!validTarget) {
            return InteractionResult.FAIL;
        }
        if (y < level.getMinBuildHeight() + 10 || y > level.getMaxBuildHeight() - 10) {
            return InteractionResult.FAIL;
        }
        BlockEntity oldBE = level.getBlockEntity(oldPos);
        CompoundTag preservedTag = null;
        if (oldBE instanceof CatalystBlockEntity) {
            CatalystBlockEntity oldCatalyst = (CatalystBlockEntity)oldBE;
            preservedTag = oldCatalyst.saveCustomData((HolderLookup.Provider)level.registryAccess());
        }
        level.setBlockAndUpdate(oldPos, Blocks.AIR.defaultBlockState());
        level.setBlockAndUpdate(newPos, oldState.getBlock().defaultBlockState());
        BlockEntity newBE = level.getBlockEntity(newPos);
        if (newBE instanceof CatalystBlockEntity) {
            CatalystBlockEntity newCatalyst = (CatalystBlockEntity)newBE;
            if (preservedTag != null) {
                newCatalyst.loadCustomData(preservedTag, (HolderLookup.Provider)level.registryAccess());
            }
        }
        level.playSound(null, oldPos, ModSounds.CATALYST_BLOCK_TELEPORT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        for (int i = 0; i < 2; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)oldPos.getX(), (double)oldPos.getY(), (double)oldPos.getZ(), (RAND.nextDouble() - 0.5) * 2.0, -RAND.nextDouble(), (RAND.nextDouble() - 0.5) * 2.0);
        }
        if (Config.catalystWandDurability) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), EquipmentSlot.MAINHAND);
        }
        context.getPlayer().getCooldowns().addCooldown((Item)this, 20);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult tryBreakCatalyst(UseOnContext context, Level level, BlockPos pos, BlockState state) {
        CatalystBlockEntity catalyst;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof CatalystBlockEntity && (catalyst = (CatalystBlockEntity)be).isUserPlaced()) {
            CompoundTag tag = catalyst.saveCustomData((HolderLookup.Provider)level.registryAccess());
            ItemStack dropped = new ItemStack((ItemLike)state.getBlock().asItem());
            dropped.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)tag));
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)dropped);
            level.removeBlock(pos, false);
            level.playSound(null, pos, SoundEvents.AMETHYST_BLOCK_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (Config.catalystWandDurability) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), EquipmentSlot.MAINHAND);
            }
            context.getPlayer().getCooldowns().addCooldown((Item)this, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

