/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.item.custom;

import com.lithiumcraft.createresourcegeodes.block.entity.CatalystBlockEntity;
import com.lithiumcraft.createresourcegeodes.config.CatalystAgitatorTier;
import com.lithiumcraft.createresourcegeodes.config.CatalystShape;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.sound.ModSounds;
import com.lithiumcraft.createresourcegeodes.util.CatalystShapeTasks;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;

public abstract class BaseCatalystAgitatorItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final Map<BlockPos, Long> lastUseTimestamps = new HashMap<BlockPos, Long>();
    private static final Map<UUID, Map<BlockPos, Integer>> failureCounts = new HashMap<UUID, Map<BlockPos, Integer>>();

    public BaseCatalystAgitatorItem(Item.Properties properties) {
        super(properties);
    }

    public abstract CatalystAgitatorTier getTier();

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.createresourcegeodes.catalyst_agitator.tooltip"));
        } else {
            CatalystAgitatorTier tier = this.getTier();
            tooltipComponents.add((Component)Component.literal((String)("Agitator Tier: " + tier.getLevel())).withStyle(ChatFormatting.DARK_PURPLE));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        int cooldown;
        long lastUsed;
        ItemStack item = context.getItemInHand();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof CatalystBlockEntity)) {
            return InteractionResult.SUCCESS;
        }
        CatalystBlockEntity catalystBE = (CatalystBlockEntity)be;
        ServerLevel serverLevel = (ServerLevel)level;
        CatalystGeneratorDefinition def = catalystBE.getGeneratorDefinition();
        if (def == null) {
            return InteractionResult.FAIL;
        }
        Item customAgitator = def.customAgitatorItem();
        ResourceLocation heldItemId = BuiltInRegistries.ITEM.getKey((Object)item.getItem());
        ResourceLocation customItemId = customAgitator != null ? BuiltInRegistries.ITEM.getKey((Object)customAgitator) : null;
        boolean isMatchingCustom = customItemId != null && heldItemId.equals((Object)customItemId);
        long gameTime = serverLevel.getGameTime();
        if (gameTime - (lastUsed = lastUseTimestamps.getOrDefault(pos, -1L).longValue()) < (long)(cooldown = def.cooldownTicks())) {
            serverLevel.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.NOTE_BLOCK_BASS, SoundSource.BLOCKS, 1.0f, 1.0f);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 8, 0.2, 0.2, 0.2, 0.01);
            return InteractionResult.FAIL;
        }
        if (customItemId != null) {
            if (!isMatchingCustom) {
                return this.handleFailureFeedback(serverLevel, pos, player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
        } else {
            CatalystAgitatorTier agitatorTier = this.getTier();
            int requiredTier = def.minimumTier();
            if (agitatorTier.getLevel() < requiredTier) {
                return this.handleFailureFeedback(serverLevel, pos, player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
            }
        }
        lastUseTimestamps.put(pos, gameTime);
        catalystBE.resetCooldown();
        Block generator = def.generatorBlock();
        CatalystShape shape = def.shape();
        int radius = def.radius();
        float fill = def.fillPercentage();
        if (!player.getAbilities().instabuild) {
            item.shrink(1);
        }
        switch (shape) {
            case SPHERE: {
                CatalystShapeTasks.queueSphere(level, pos, generator, radius, fill);
                break;
            }
            case CUBE: {
                CatalystShapeTasks.queueCube(level, pos, generator, radius, fill);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private boolean handleFailureFeedback(ServerLevel level, BlockPos pos, @Nullable Player player) {
        UUID playerId = player != null ? player.getUUID() : UUID.randomUUID();
        Map blockFailures = failureCounts.computeIfAbsent(playerId, k -> new HashMap());
        int fails = blockFailures.getOrDefault(pos, 0);
        if (fails < 10) {
            SoundEvent sound = fails == 9 ? ModSounds.DONT_BE_A_BOT.get() : ModSounds.AGITATOR_INVALID_TIER.get();
            level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, 8, 0.2, 0.2, 0.2, 0.01);
            blockFailures.put(pos, fails + 1);
        } else {
            Map<BlockPos, Integer> existing = failureCounts.get(playerId);
            if (existing != null) {
                existing.remove(pos);
            }
        }
        return false;
    }
}

