/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.network;

import com.google.gson.JsonParser;
import com.lithiumcraft.createresourcegeodes.CreateResourceGeodes;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public record ClientboundCatalystRegistryPacket(Map<ResourceLocation, CatalystGeneratorDefinition> definitions) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"createresourcegeodes", (String)"sync_catalyst_registry");
    public static final CustomPacketPayload.Type<ClientboundCatalystRegistryPacket> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, ClientboundCatalystRegistryPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
        buf.writeVarInt(packet.definitions.size());
        for (Map.Entry<ResourceLocation, CatalystGeneratorDefinition> entry : packet.definitions.entrySet()) {
            buf.writeResourceLocation(entry.getKey());
            CatalystGeneratorDefinition.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(error -> CreateResourceGeodes.LOGGER.error("Failed to encode catalyst '{}': {}", entry.getKey(), error)).ifPresent(json -> buf.writeUtf(json.toString()));
        }
    }, buf -> {
        int size = buf.readVarInt();
        HashMap<ResourceLocation, CatalystGeneratorDefinition> defs = new HashMap<ResourceLocation, CatalystGeneratorDefinition>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            String json = buf.readUtf();
            CatalystGeneratorDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)json)).resultOrPartial(err -> CreateResourceGeodes.LOGGER.error("Failed to decode catalyst '{}': {}", (Object)id, err)).ifPresent(def -> defs.put(id, (CatalystGeneratorDefinition)def));
        }
        return new ClientboundCatalystRegistryPacket(defs);
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

