/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.util;

import com.lithiumcraft.createresourcegeodes.config.CatalystShape;
import com.lithiumcraft.createresourcegeodes.data.CatalystGeneratorDefinition;
import com.lithiumcraft.createresourcegeodes.registry.ModRegistries;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Block;

public interface CatalystDataProvider {
    public ResourceLocation getCatalystId();

    public Block getDefaultGeneratorBlock();

    default public int getDefaultCooldown() {
        return 120;
    }

    default public CatalystShape getDefaultShape() {
        return CatalystShape.SPHERE;
    }

    default public int getDefaultMinimumTier() {
        return 1;
    }

    default public int getDefaultRadius() {
        return 4;
    }

    default public float getDefaultFillPercentage() {
        return 0.35f;
    }

    default public Block getGeneratorBlock(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.generatorBlock() : this.getDefaultGeneratorBlock();
    }

    default public int getCooldown(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.cooldownTicks() : this.getDefaultCooldown();
    }

    default public CatalystShape getShape(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.shape() : this.getDefaultShape();
    }

    default public int getMinimumTier(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.minimumTier() : this.getDefaultMinimumTier();
    }

    default public int getRadius(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.radius() : this.getDefaultRadius();
    }

    default public float getFillPercentage(ServerLevel level) {
        Registry registry = level.registryAccess().registryOrThrow(ModRegistries.CATALYST_DEFINITION_KEY);
        CatalystGeneratorDefinition def = (CatalystGeneratorDefinition)registry.get(this.getCatalystId());
        return def != null ? def.fillPercentage() : this.getDefaultFillPercentage();
    }
}

