/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.createresourcegeodes.util;

import com.lithiumcraft.createresourcegeodes.Config;
import com.lithiumcraft.createresourcegeodes.util.BlockPlacerTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CatalystShapeTasks {
    private static final List<BlockPlacerTask> ACTIVE_TASKS = new ArrayList<BlockPlacerTask>();

    public static void queueSphere(Level level, BlockPos center, Block block, int radius, float fill) {
        ACTIVE_TASKS.add(new SpherePlacer(level, center, block, radius, fill));
    }

    public static void queueCube(Level level, BlockPos center, Block block, int radius, float fill) {
        ACTIVE_TASKS.add(new CubePlacer(level, center, block, radius, fill));
    }

    public static void tick(MinecraftServer server) {
        Iterator<BlockPlacerTask> iterator = ACTIVE_TASKS.iterator();
        while (iterator.hasNext()) {
            BlockPlacerTask task = iterator.next();
            task.tick();
            if (!task.isDone()) continue;
            iterator.remove();
        }
    }

    private static class SpherePlacer
    implements BlockPlacerTask {
        private final ServerLevel level;
        private final Queue<BlockPos> positions = new LinkedList<BlockPos>();
        private final Block block;
        private static final Random RAND = new Random();
        private int delayTicks = 40;

        public SpherePlacer(Level level, BlockPos center, Block block, int radius, float fillPercentage) {
            this.level = (ServerLevel)level;
            this.block = block;
            ArrayList<BlockPos> allPositions = new ArrayList<BlockPos>();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        pos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        allPositions.add(pos.immutable());
                    }
                }
            }
            Collections.shuffle(allPositions, RAND);
            int count = Math.round((float)allPositions.size() * fillPercentage);
            this.positions.addAll(allPositions.subList(0, count));
        }

        @Override
        public void tick() {
            if (this.delayTicks-- > 0) {
                return;
            }
            for (int i = 0; i < Config.catalystBlocksPerTick && !this.positions.isEmpty(); ++i) {
                BlockPos pos = this.positions.poll();
                if (!this.level.isInWorldBounds(pos) || !this.level.getBlockState(pos).isAir()) continue;
                this.level.setBlock(pos, this.block.defaultBlockState(), 3);
            }
        }

        @Override
        public boolean isDone() {
            return this.delayTicks <= 0 && this.positions.isEmpty();
        }
    }

    private static class CubePlacer
    implements BlockPlacerTask {
        private final ServerLevel level;
        private final Queue<BlockPos> positions = new LinkedList<BlockPos>();
        private final Block block;
        private static final Random RAND = new Random();
        private int delayTicks = 40;

        public CubePlacer(Level level, BlockPos center, Block block, int radius, float fillPercentage) {
            this.level = (ServerLevel)level;
            this.block = block;
            ArrayList<BlockPos> allPositions = new ArrayList<BlockPos>();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        pos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        allPositions.add(pos.immutable());
                    }
                }
            }
            Collections.shuffle(allPositions, RAND);
            int count = Math.round((float)allPositions.size() * fillPercentage);
            this.positions.addAll(allPositions.subList(0, count));
        }

        @Override
        public void tick() {
            if (this.delayTicks-- > 0) {
                return;
            }
            for (int i = 0; i < Config.catalystBlocksPerTick && !this.positions.isEmpty(); ++i) {
                BlockPos pos = this.positions.poll();
                if (!this.level.isInWorldBounds(pos) || !this.level.getBlockState(pos).isAir()) continue;
                this.level.setBlock(pos, this.block.defaultBlockState(), 3);
            }
        }

        @Override
        public boolean isDone() {
            return this.delayTicks <= 0 && this.positions.isEmpty();
        }
    }
}

