/*
 * Decompiled with CFR 0.152.
 */
package me.ancientri.rimelib.config;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ancientri.rimelib.config.ConfigBuilder;
import me.ancientri.rimelib.config.events.OnLoad;
import me.ancientri.rimelib.config.events.OnSave;
import me.ancientri.rimelib.util.EventUtil;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0003*\b\b\u0002\u0010\u0005*\u00020\u00012\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0007J\u0017\u0010\u000b\u001a\u00028\u00012\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0002H&\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00028\u00022\u0006\u0010\u000e\u001a\u00020\u0012H&\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00028\u00022\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u0002H&\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J&\u0010\u001c\u001a\u00028\u00002\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0004\b\u001c\u0010\u001dJ&\u0010\u001e\u001a\u00028\u00002\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u001a\u00a2\u0006\u0002\b\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010!\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010*\u001a\u00020'8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00028\u00008&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\"R*\u0010\n\u001a\u00028\u00002\u0006\u0010-\u001a\u00028\u00008\u0006@DX\u0086.\u00a2\u0006\u0012\n\u0004\b\n\u0010.\u001a\u0004\b/\u0010\"\"\u0004\b0\u0010 R\u0011\u00102\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010)R\u001d\u00105\u001a\b\u0012\u0004\u0012\u000204038\u0006\u00a2\u0006\f\n\u0004\b5\u00106\u001a\u0004\b7\u00108R#\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u000009038\u0006\u00a2\u0006\f\n\u0004\b:\u00106\u001a\u0004\b;\u00108\u00a8\u0006<"}, d2={"Lme/ancientri/rimelib/config/ConfigManager;", "", "C", "Lme/ancientri/rimelib/config/ConfigBuilder;", "B", "F", "<init>", "()V", "", "init", "config", "builder", "(Ljava/lang/Object;)Lme/ancientri/rimelib/config/ConfigBuilder;", "Ljava/io/OutputStream;", "stream", "data", "writeToStream", "(Ljava/io/OutputStream;Ljava/lang/Object;)V", "Ljava/io/InputStream;", "readFromStream", "(Ljava/io/InputStream;)Ljava/lang/Object;", "encode", "(Ljava/lang/Object;)Ljava/lang/Object;", "decode", "applyBuilder", "(Lme/ancientri/rimelib/config/ConfigBuilder;)Ljava/lang/Object;", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "modifyConfig", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "updateConfig", "saveConfig", "(Ljava/lang/Object;)V", "loadConfig", "()Ljava/lang/Object;", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "logger", "Ljava/nio/file/Path;", "getConfigPath", "()Ljava/nio/file/Path;", "configPath", "getDefault", "default", "value", "Ljava/lang/Object;", "getConfig", "setConfig", "getRelativePath", "relativePath", "Lnet/fabricmc/fabric/api/event/Event;", "Lme/ancientri/rimelib/config/events/OnSave;", "ON_SAVE", "Lnet/fabricmc/fabric/api/event/Event;", "getON_SAVE", "()Lnet/fabricmc/fabric/api/event/Event;", "Lme/ancientri/rimelib/config/events/OnLoad;", "ON_LOAD", "getON_LOAD", "rimelib"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nme/ancientri/rimelib/config/ConfigManager\n+ 2 EventUtil.kt\nme/ancientri/rimelib/util/EventUtil\n+ 3 StaticUtil.kt\nme/ancientri/rimelib/util/StaticUtilKt\n*L\n1#1,235:1\n24#2:236\n24#2:237\n18#3:238\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nme/ancientri/rimelib/config/ConfigManager\n*L\n73#1:236\n84#1:237\n68#1:238\n*E\n"})
public abstract class ConfigManager<C, B extends ConfigBuilder<C>, F> {
    protected C config;
    @NotNull
    private final Event<OnSave> ON_SAVE;
    @NotNull
    private final Event<OnLoad<C>> ON_LOAD;

    public ConfigManager() {
        EventUtil eventUtil = EventUtil.INSTANCE;
        Function<Object[], Object> invokerFactory$iv = ConfigManager::ON_SAVE$lambda$0;
        boolean $i$f$createArrayBacked = false;
        Event event = EventFactory.createArrayBacked(OnSave.class, invokerFactory$iv);
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"createArrayBacked(...)");
        this.ON_SAVE = event;
        EventUtil this_$iv = EventUtil.INSTANCE;
        invokerFactory$iv = ConfigManager::ON_LOAD$lambda$0;
        $i$f$createArrayBacked = false;
        Event event2 = EventFactory.createArrayBacked(OnLoad.class, invokerFactory$iv);
        Intrinsics.checkNotNullExpressionValue((Object)event2, (String)"createArrayBacked(...)");
        this.ON_LOAD = event2;
    }

    @NotNull
    public abstract Logger getLogger();

    @NotNull
    public abstract Path getConfigPath();

    @NotNull
    public abstract C getDefault();

    @NotNull
    public final C getConfig() {
        C c = this.config;
        if (c != null) {
            return c;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return (C)Unit.INSTANCE;
    }

    protected final void setConfig(@NotNull C c) {
        Intrinsics.checkNotNullParameter(c, (String)"<set-?>");
        this.config = c;
    }

    @NotNull
    public final Path getRelativePath() {
        boolean $i$f$getFabricLoader = false;
        FabricLoader fabricLoader = FabricLoader.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fabricLoader, (String)"getInstance(...)");
        Path path = fabricLoader.getConfigDir().relativize(this.getConfigPath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"relativize(...)");
        return path;
    }

    @NotNull
    public final Event<OnSave> getON_SAVE() {
        return this.ON_SAVE;
    }

    @NotNull
    public final Event<OnLoad<C>> getON_LOAD() {
        return this.ON_LOAD;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        C c;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.getConfigPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.getLogger().warn("Config file {} does not exist, creating with default values.", (Object)this.getRelativePath());
            this.saveConfig(this.getDefault());
            c = this.getDefault();
        } else {
            C loadedConfig = this.loadConfig();
            if (loadedConfig == null) {
                this.getLogger().warn("Config file {} could not be loaded, using default values.", (Object)this.getRelativePath());
                c = this.getDefault();
            } else {
                void var1_1;
                this.getLogger().info("Loaded config file {}.", (Object)this.getRelativePath());
                c = var1_1;
            }
        }
        this.setConfig(c);
        ((OnLoad)this.ON_LOAD.invoker()).onLoad(this.getConfig());
    }

    @NotNull
    public abstract B builder(@NotNull C var1);

    public abstract void writeToStream(@NotNull OutputStream var1, @NotNull F var2);

    @NotNull
    public abstract F readFromStream(@NotNull InputStream var1);

    @NotNull
    public abstract F encode(@NotNull C var1);

    @NotNull
    public abstract C decode(@NotNull F var1);

    @NotNull
    public final C applyBuilder(@NotNull B builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.setConfig(builder.build());
        return this.getConfig();
    }

    @NotNull
    public final C modifyConfig(@NotNull Function1<? super B, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        B b = this.builder(this.getConfig());
        builder.invoke(b);
        return this.applyBuilder(b);
    }

    @NotNull
    public final C updateConfig(@NotNull Function1<? super B, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.saveConfig(this.modifyConfig(builder));
        return this.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveConfig(@NotNull C config) {
        Object object;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.getLogger().info("Saving config to file: {}", (Object)this.getRelativePath());
        this.getLogger().debug("Encoding config: {}", config);
        try {
            object = this.encode(config);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to encode config for saving: {}", (Object)e.getMessage(), (Object)e);
            return;
        }
        F encoded = object;
        this.getLogger().debug("Encoded config: {}", encoded);
        PathsKt.createParentDirectories((Path)this.getConfigPath(), (FileAttribute[])new FileAttribute[0]);
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(this.getConfigPath(), Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object = outputStream;
        Throwable throwable = null;
        try {
            OutputStream writer = (OutputStream)object;
            boolean bl = false;
            try {
                this.writeToStream(writer, encoded);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{this.getRelativePath(), e.getMessage(), e};
                this.getLogger().error("Failed to write config to file {}: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(object, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void saveConfig$default(ConfigManager configManager, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: saveConfig");
        }
        if ((n & 1) != 0) {
            object = configManager.getConfig();
        }
        configManager.saveConfig(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final C loadConfig() {
        InputStream reader;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(this.getConfigPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(this.getConfigPath(), Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            F f;
            reader = (InputStream)closeable;
            boolean bl = false;
            try {
                f = this.readFromStream(reader);
            }
            catch (Exception e) {
                Object[] objectArray = new Object[]{this.getRelativePath(), e.getMessage(), e};
                this.getLogger().error("Failed to read file {}: {}", objectArray);
                C c = null;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return c;
            }
            reader = f;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        InputStream readResult = reader;
        this.getLogger().debug("Read config file: {}", (Object)readResult);
        try {
            throwable = this.decode(readResult);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{this.getRelativePath(), e.getMessage(), e};
            this.getLogger().error("Failed to decode config from file {}: {}", objectArray);
            return null;
        }
        Throwable decoded = throwable;
        this.getLogger().debug("Decoded config: {}", (Object)decoded);
        return (C)decoded;
    }

    private static final OnSave ON_SAVE$lambda$0(OnSave[] listeners) {
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        return () -> ConfigManager.ON_SAVE$lambda$0$0(listeners);
    }

    private static final void ON_SAVE$lambda$0$0(OnSave[] $listeners) {
        Intrinsics.checkNotNull((Object)$listeners);
        for (OnSave listener : $listeners) {
            listener.onSave();
        }
    }

    private static final OnLoad ON_LOAD$lambda$0(OnLoad[] listeners) {
        Intrinsics.checkNotNullParameter((Object)listeners, (String)"listeners");
        return arg_0 -> ConfigManager.ON_LOAD$lambda$0$0(listeners, arg_0);
    }

    private static final void ON_LOAD$lambda$0$0(OnLoad[] $listeners, Object config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNull((Object)$listeners);
        for (OnLoad listener : $listeners) {
            listener.onLoad(config);
        }
    }
}

