/*
 * Decompiled with CFR 0.152.
 */
package me.ancientri.rimelib.config.dfu;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import me.ancientri.rimelib.config.ConfigBuilder;
import me.ancientri.rimelib.config.ConfigManager;
import me.ancientri.rimelib.config.exceptions.DecodeException;
import me.ancientri.rimelib.config.exceptions.EncodeException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u0003*\b\b\u0002\u0010\u0005*\u00020\u00012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0006B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00028\u00022\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00020\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lme/ancientri/rimelib/config/dfu/CodecConfigManager;", "", "C", "Lme/ancientri/rimelib/config/ConfigBuilder;", "B", "F", "Lme/ancientri/rimelib/config/ConfigManager;", "<init>", "()V", "config", "encode", "(Ljava/lang/Object;)Ljava/lang/Object;", "data", "decode", "Lcom/mojang/serialization/Codec;", "getCodec", "()Lcom/mojang/serialization/Codec;", "codec", "Lcom/mojang/serialization/DynamicOps;", "getOps", "()Lcom/mojang/serialization/DynamicOps;", "ops", "rimelib"})
public abstract class CodecConfigManager<C, B extends ConfigBuilder<C>, F>
extends ConfigManager<C, B, F> {
    @NotNull
    public abstract Codec<C> getCodec();

    @NotNull
    public abstract DynamicOps<F> getOps();

    @Override
    @NotNull
    public F encode(@NotNull C config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        DataResult result = this.getCodec().encodeStart(this.getOps(), config);
        if (!(result instanceof DataResult.Success)) {
            if (result instanceof DataResult.Error) {
                String string = ((DataResult.Error)result).message();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new EncodeException(string, null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object = ((DataResult.Success)result).value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        return (F)object;
    }

    @Override
    @NotNull
    public C decode(@NotNull F data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        DataResult result = this.getCodec().decode(this.getOps(), data);
        if (!(result instanceof DataResult.Success)) {
            if (result instanceof DataResult.Error) {
                String string = ((DataResult.Error)result).message();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                throw new DecodeException(string, null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        Object object = ((Pair)((DataResult.Success)result).value()).getFirst();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getFirst(...)");
        return (C)object;
    }
}

