/*
 * Decompiled with CFR 0.152.
 */
package me.ancientri.rimelib.util;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import me.ancientri.rimelib.util.Debug;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.slf4j.Log4jLogger;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\b\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\nH\u0086\b\u00a2\u0006\u0004\b\b\u0010\fJ\u001c\u0010\b\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\rH\u0086\b\u00a2\u0006\u0004\b\b\u0010\u000eJ\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001H\u0086\b\u00a2\u0006\u0004\b\b\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lme/ancientri/rimelib/util/LoggerFactory;", "", "", "prefix", "<init>", "(Ljava/lang/String;)V", "name", "Lorg/slf4j/Logger;", "createLogger", "(Ljava/lang/String;)Lorg/slf4j/Logger;", "Lkotlin/reflect/KClass;", "clazz", "(Lkotlin/reflect/KClass;)Lorg/slf4j/Logger;", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lorg/slf4j/Logger;", "this", "(Ljava/lang/Object;)Lorg/slf4j/Logger;", "Ljava/lang/String;", "rimelib"})
public final class LoggerFactory {
    @NotNull
    private final String prefix;

    public LoggerFactory(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.prefix = prefix;
    }

    @NotNull
    public final Logger createLogger(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Logger logger = org.slf4j.LoggerFactory.getLogger((String)(this.prefix + " | " + name));
        if (Debug.INSTANCE.isEnabled() && logger instanceof Log4jLogger) {
            org.apache.logging.log4j.spi.LoggerContext loggerContext = LogManager.getContext((boolean)false);
            Intrinsics.checkNotNull((Object)loggerContext, (String)"null cannot be cast to non-null type org.apache.logging.log4j.core.LoggerContext");
            LoggerContext ctx = (LoggerContext)loggerContext;
            LoggerConfig loggerConfig = ctx.getConfiguration().getLoggerConfig(((Log4jLogger)logger).getName());
            if (!Intrinsics.areEqual((Object)loggerConfig.getName(), (Object)((Log4jLogger)logger).getName())) {
                loggerConfig = new LoggerConfig(((Log4jLogger)logger).getName(), Level.DEBUG, true);
                LoggerConfig rootLoggerConfig = ctx.getConfiguration().getRootLogger();
                Map map = rootLoggerConfig.getAppenders();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAppenders(...)");
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Appender appender = (Appender)entry.getValue();
                    if (!Intrinsics.areEqual((Object)key, (Object)"SysOut") && !Intrinsics.areEqual((Object)key, (Object)"DebugFile") && !Intrinsics.areEqual((Object)key, (Object)"LatestFile")) continue;
                    loggerConfig.addAppender(appender, Level.ALL, null);
                }
                ctx.getConfiguration().addLogger(((Log4jLogger)logger).getName(), loggerConfig);
            } else {
                loggerConfig.setLevel(Level.DEBUG);
            }
            ctx.updateLoggers();
        }
        Intrinsics.checkNotNull((Object)logger);
        return logger;
    }

    @NotNull
    public final Logger createLogger(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        boolean $i$f$createLogger = false;
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return this.createLogger(string);
    }

    @NotNull
    public final Logger createLogger(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        boolean $i$f$createLogger = false;
        String string = clazz.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return this.createLogger(string);
    }

    @NotNull
    public final Logger createLogger(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this");
        boolean $i$f$createLogger = false;
        String string = Reflection.getOrCreateKotlinClass(object.getClass()).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        return this.createLogger(string);
    }
}

