/*
 * Decompiled with CFR 0.152.
 */
package me.ancientri.rimelib.config.kotlinx;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import me.ancientri.rimelib.config.ConfigBuilder;
import me.ancientri.rimelib.config.exceptions.DecodeException;
import me.ancientri.rimelib.config.exceptions.EncodeException;
import me.ancientri.rimelib.config.kotlinx.SerializerConfigManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u0001*\u000e\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\u00060\u0005B\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001a\u001a\u00020\u00178&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lme/ancientri/rimelib/config/kotlinx/StringSerializerConfigManager;", "", "C", "Lme/ancientri/rimelib/config/ConfigBuilder;", "B", "Lme/ancientri/rimelib/config/kotlinx/SerializerConfigManager;", "", "<init>", "()V", "config", "encode", "(Ljava/lang/Object;)Ljava/lang/String;", "data", "decode", "(Ljava/lang/String;)Ljava/lang/Object;", "Ljava/io/OutputStream;", "stream", "", "writeToStream", "(Ljava/io/OutputStream;Ljava/lang/String;)V", "Ljava/io/InputStream;", "readFromStream", "(Ljava/io/InputStream;)Ljava/lang/String;", "Lkotlinx/serialization/StringFormat;", "getSerialFormat", "()Lkotlinx/serialization/StringFormat;", "serialFormat", "rimelib"})
public abstract class StringSerializerConfigManager<C, B extends ConfigBuilder<C>>
extends SerializerConfigManager<C, B, String> {
    @NotNull
    public abstract StringFormat getSerialFormat();

    @Override
    @NotNull
    public String encode(@NotNull C config) {
        String string;
        Intrinsics.checkNotNullParameter(config, (String)"config");
        try {
            string = this.getSerialFormat().encodeToString((SerializationStrategy)this.getSerializer(), config);
        }
        catch (Exception e) {
            throw new EncodeException(e);
        }
        return string;
    }

    @Override
    @NotNull
    public C decode(@NotNull String data) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            object = this.getSerialFormat().decodeFromString((DeserializationStrategy)this.getSerializer(), data);
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
        return (C)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToStream(@NotNull OutputStream stream, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)closeable;
            boolean bl = false;
            writer2.write(data);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String readFromStream(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Closeable closeable = stream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            object2 = TextStreamsKt.readText((Reader)reader);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return object2;
    }
}

