/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("LeonLeRobot.yml").toFile();
    private static final boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_FAVORITE_PLAYER = "DrEmixam";
    private static final boolean DEFAULT_STREAMER_MODE = false;
    private Map<String, Object> config;

    public ConfigManager() {
        this.loadConfig();
    }

    private void loadConfig() {
        if (!CONFIG_FILE.exists()) {
            this.createDefaultConfig();
        }
        Yaml yaml = new Yaml();
        try (FileInputStream fis = new FileInputStream(CONFIG_FILE);){
            this.config = (Map)yaml.load((InputStream)fis);
            if (this.config == null) {
                this.config = new LinkedHashMap<String, Object>();
            }
        }
        catch (IOException e) {
            System.err.println("Erreur lors du chargement de la configuration: " + e.getMessage());
            this.config = new LinkedHashMap<String, Object>();
        }
        this.ensureDefaultValues();
    }

    private void createDefaultConfig() {
        LinkedHashMap<String, Object> defaultConfig = new LinkedHashMap<String, Object>();
        defaultConfig.put("enabled", true);
        defaultConfig.put("favorite_player", DEFAULT_FAVORITE_PLAYER);
        this.saveConfigToFile(defaultConfig);
    }

    private void ensureDefaultValues() {
        boolean needsSave = false;
        if (!this.config.containsKey("enabled")) {
            this.config.put("enabled", true);
            needsSave = true;
        }
        if (!this.config.containsKey("favorite_player")) {
            this.config.put("favorite_player", DEFAULT_FAVORITE_PLAYER);
            needsSave = true;
        }
        if (!this.config.containsKey("streamer_mode")) {
            this.config.put("streamer_mode", false);
        }
        if (needsSave) {
            this.saveVisibleConfig();
        }
    }

    private void saveVisibleConfig() {
        LinkedHashMap<String, Object> visibleConfig = new LinkedHashMap<String, Object>();
        visibleConfig.put("enabled", this.config.getOrDefault("enabled", true));
        visibleConfig.put("favorite_player", this.config.getOrDefault("favorite_player", DEFAULT_FAVORITE_PLAYER));
        this.saveConfigToFile(visibleConfig);
    }

    private void saveConfigToFile(Map<String, Object> configToSave) {
        block7: {
            try {
                if (!CONFIG_FILE.getParentFile().mkdirs()) break block7;
                DumperOptions options = new DumperOptions();
                options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                options.setPrettyFlow(true);
                options.setIndent(2);
                Yaml yaml = new Yaml(options);
                try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                    yaml.dump(configToSave, (Writer)writer);
                }
            }
            catch (IOException e) {
                System.err.println("Erreur lors de la sauvegarde de la configuration: " + e.getMessage());
            }
        }
    }

    public String getFavoritePlayerName() {
        return (String)this.config.getOrDefault("favorite_player", DEFAULT_FAVORITE_PLAYER);
    }

    public boolean isRulesEnabled() {
        return (Boolean)this.config.getOrDefault("enabled", true);
    }

    public boolean isStreamerEnabled() {
        return (Boolean)this.config.getOrDefault("streamer_mode", false);
    }
}

