/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot;

import com.dremixam.leonlerobot.LeonEventHandler;
import com.dremixam.leonlerobot.SoundEventManager;
import com.dremixam.leonlerobot.goals.AvoidCatGoal;
import com.dremixam.leonlerobot.goals.BreakLeashGoal;
import com.dremixam.leonlerobot.goals.ExitVehicleGoal;
import com.dremixam.leonlerobot.goals.FollowPlayerGoal;
import com.dremixam.leonlerobot.goals.ManageFocusedPlayerGoal;
import com.dremixam.leonlerobot.goals.RemovePassengerGoal;
import com.dremixam.leonlerobot.goals.SayRandomVoiceLineGoal;
import com.dremixam.leonlerobot.goals.StayWithFavoritePlayerGoal;
import com.dremixam.leonlerobot.goals.WanderAroundSpawnGoal;
import com.dremixam.leonlerobot.goals.WanderNearFocusedGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1331;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3483;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_8103;
import net.minecraft.class_8110;

public class LeonLeRobotEntity
extends class_1314 {
    public static final double BASE_SPEED = 5.0;
    public static final double WANDER_SPEED = 1.0;
    public static final double MAX_SPEED = 10.0;
    public static final double FOLLOW_RADIUS = 5.0;
    public static final double WANDER_RADIUS = 15.0;
    public static final double OUT_OF_VIEW_RADIUS = 48.0;
    public static final float MAX_CAT_DISTANCE = 5.0f;
    public static final int FOCUSED_PLAYER_MIN_TIMEOUT = 3600;
    public static final int FOCUSED_PLAYER_MAX_TIMEOUT = 12000;
    public static final int TICKS_BETWEEN_VOICE = 120;
    public static final int MIN_TICKS_BETWEEN_RANDOM_VOICE = 600;
    public static final int MAX_TICKS_BETWEEN_RANDOM_VOICE = 2400;
    public static final float JOKE_PROBABILITY = 0.05f;
    public static final int MAX_HEAD_ROTATION = 75;
    public static final int MAX_LOOK_PITCH_CHANGE = 10;
    public static final int MAX_LOOK_YAW_CHANGE = 1;
    private static final int PLAYER_HIT_MEMORY_TICKS = 1200;
    private static final int DO_NOT_FOCUS_TIMEOUT_TICKS = 72000;
    private static LeonLeRobotEntity instance = null;
    private static final List<PlayerHitRecord> recentPlayerHits = Collections.synchronizedList(new ArrayList());
    private static final Map<class_1657, Integer> doNotFocusPlayers = new HashMap<class_1657, Integer>();
    protected class_1657 focusedEntity = null;
    protected int lastSpokeAge = -1;
    protected Mood mood = Mood.NEUTRAL;
    protected static boolean isStreamControlled = false;
    protected boolean isStreamSpeaking = false;

    public LeonLeRobotEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        if (instance == null) {
            instance = this;
            this.method_5875(true);
            this.field_6207 = new class_1331((class_1308)this, 10, true);
        }
    }

    public static LeonLeRobotEntity getInstance() {
        if (instance == null) {
            System.err.println("[LeonLeRobotEntity] Aucune instance de Leon Le Robot n'a \u00e9t\u00e9 cr\u00e9\u00e9e !");
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public static class_5132.class_5133 createLeonLeRobotAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 100.0).method_26868(class_5134.field_23720, (double)0.4f).method_26868(class_5134.field_23719, (double)0.2f);
    }

    public boolean canFocus(class_1657 player) {
        return !doNotFocusPlayers.containsKey(player) || doNotFocusPlayers.get(player) <= this.field_6012;
    }

    public class_1309 getFocused() {
        return this.focusedEntity;
    }

    public void setFocused(class_1657 entity) {
        this.focusedEntity = entity;
    }

    public Mood getMood() {
        return this.mood;
    }

    public void setMood(Mood mood) {
        if (!this.method_37908().method_8608()) {
            switch (mood.ordinal()) {
                case 0: {
                    this.method_37908().method_8421((class_1297)this, (byte)10);
                    break;
                }
                case 1: {
                    this.method_37908().method_8421((class_1297)this, (byte)11);
                    break;
                }
                case 2: {
                    this.method_37908().method_8421((class_1297)this, (byte)12);
                    break;
                }
                case 3: {
                    this.method_37908().method_8421((class_1297)this, (byte)13);
                    break;
                }
                case 4: {
                    this.method_37908().method_8421((class_1297)this, (byte)14);
                    break;
                }
                case 5: {
                    this.method_37908().method_8421((class_1297)this, (byte)15);
                    break;
                }
                case 6: {
                    this.method_37908().method_8421((class_1297)this, (byte)16);
                }
            }
        }
        this.mood = mood;
    }

    public boolean isStreamControlled() {
        return isStreamControlled;
    }

    public void setStreamControlled(boolean streamControlled) {
        isStreamControlled = streamControlled;
    }

    public boolean isStreamSpeaking() {
        return this.isStreamSpeaking;
    }

    public void setStreamSpeaking(boolean streamSpeaking) {
        if (!this.method_37908().method_8608()) {
            if (streamSpeaking && isStreamControlled) {
                this.method_37908().method_8421((class_1297)this, (byte)17);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)18);
            }
        }
        this.isStreamSpeaking = streamSpeaking;
    }

    protected class_3414 method_5994() {
        return SoundEventManager.LEON_SOUND_EVENT;
    }

    public int method_5970() {
        return 1200;
    }

    protected class_3414 method_6011(class_1282 source) {
        if (source.method_5529() instanceof class_1657) {
            return SoundEventManager.LEON_VOICE_ANGRY_SOUND_EVENT;
        }
        return SoundEventManager.LEON_VOICE_HURT_SOUND_EVENT;
    }

    public int method_5986() {
        return 75;
    }

    public int method_5978() {
        return 10;
    }

    public int method_20240() {
        return 1;
    }

    public boolean method_17326() {
        return this == instance;
    }

    public boolean method_5947() {
        return this == instance;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected boolean method_39759(class_243 adjustedMovement) {
        return true;
    }

    public boolean method_5643(class_1282 sourceOfDamage, float damageTaken) {
        class_1297 sourceEntity;
        if (this != instance) {
            this.method_6074(sourceOfDamage, damageTaken);
            return true;
        }
        if (this.method_5679(sourceOfDamage)) {
            return false;
        }
        if (this.method_37908().field_9236) {
            return false;
        }
        if (this.method_29504()) {
            return false;
        }
        if (sourceOfDamage.method_48789(class_8103.field_42246) && this.method_6059(class_1294.field_5918)) {
            return false;
        }
        if (this.method_6113() && !this.method_37908().field_9236) {
            this.method_18400();
        }
        class_8110 damageType = sourceOfDamage.method_48792();
        if (sourceOfDamage.method_48789(class_8103.field_42250) || sourceOfDamage.method_48789(class_8103.field_42241) || damageType.comp_1242().equals("inWall") || damageType.comp_1242().equals("cramming") || damageType.comp_1242().equals("fall")) {
            this.field_28627 = 0.0f;
            return false;
        }
        this.field_6278 = 0;
        float damageDealt = damageTaken;
        if (sourceOfDamage.method_48789(class_8103.field_42252) && this.method_5864().method_20210(class_3483.field_29826)) {
            damageTaken *= 5.0f;
        }
        this.field_42108.method_48567(1.5f);
        boolean bl2 = true;
        if ((float)this.field_6008 > 10.0f && !sourceOfDamage.method_48789(class_8103.field_42969)) {
            if (damageTaken <= this.field_6253) {
                return false;
            }
            this.method_6074(sourceOfDamage, damageTaken - this.field_6253);
            this.field_6253 = damageTaken;
            bl2 = false;
        } else {
            this.field_6253 = damageTaken;
            this.field_6008 = 20;
            this.method_6074(sourceOfDamage, damageTaken);
            this.field_6235 = this.field_6254 = 10;
        }
        if (sourceOfDamage.method_48789(class_8103.field_42240) && !this.method_6118(class_1304.field_6169).method_7960()) {
            this.method_36977(sourceOfDamage, damageTaken);
            damageTaken *= 0.75f;
        }
        if ((sourceEntity = sourceOfDamage.method_5526()) instanceof class_1657) {
            class_1657 player = (class_1657)sourceEntity;
            int currentTick = this.field_6012;
            recentPlayerHits.add(new PlayerHitRecord(currentTick, player));
            recentPlayerHits.removeIf(hit -> currentTick - hit.tick > 1200);
            long hits = recentPlayerHits.stream().filter(hit -> hit.player.equals((Object)player)).count();
            if (hits >= 3L && !doNotFocusPlayers.containsKey(player)) {
                doNotFocusPlayers.put(player, currentTick + 72000);
                this.playVoiceSound(SoundEventManager.LEON_VOICE_GOAWAY_SOUND_EVENT);
            }
        }
        int currentTick = this.field_6012;
        doNotFocusPlayers.entrySet().removeIf(entry -> (Integer)entry.getValue() <= currentTick);
        class_1297 sourceEntity2 = sourceOfDamage.method_5529();
        if (sourceEntity2 != null) {
            class_1493 wolfEntity;
            if (sourceEntity2 instanceof class_1309) {
                class_1309 livingEntity2 = (class_1309)sourceEntity2;
                if (!sourceOfDamage.method_48789(class_8103.field_42254)) {
                    this.method_6015(livingEntity2);
                }
            }
            if (sourceEntity2 instanceof class_1657) {
                class_1657 playerEntity = (class_1657)sourceEntity2;
                this.field_6238 = 100;
                this.field_6258 = playerEntity;
            } else if (sourceEntity2 instanceof class_1493 && (wolfEntity = (class_1493)sourceEntity2).method_6181()) {
                this.field_6238 = 100;
                class_1309 var11 = wolfEntity.method_35057();
                this.field_6258 = var11 instanceof class_1657 ? (class_1657)var11 : null;
            }
        }
        if (bl2) {
            this.method_37908().method_48760((class_1297)this, sourceOfDamage);
            if (!sourceOfDamage.method_48789(class_8103.field_42255)) {
                this.method_5785();
            }
            if (sourceEntity2 != null && !sourceOfDamage.method_48789(class_8103.field_42249)) {
                double d = sourceEntity2.method_23317() - this.method_23317();
                double e = sourceEntity2.method_23321() - this.method_23321();
                while (d * d + e * e < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    e = (Math.random() - Math.random()) * 0.01;
                }
                this.method_6005(0.4f, d, e);
                this.method_48761(d, e);
            }
        }
        this.method_6013(sourceOfDamage);
        if (sourceEntity2 instanceof class_3222) {
            class_174.field_1199.method_9097((class_3222)sourceEntity2, (class_1297)this, sourceOfDamage, damageDealt, damageTaken, false);
        }
        return true;
    }

    protected void method_6013(class_1282 source) {
        class_3414 soundEvent = this.method_6011(source);
        if (soundEvent != null) {
            this.playVoiceSound(soundEvent);
        }
    }

    public void method_48922(class_1282 damageSource) {
        String description;
        super.method_48922(damageSource);
        if (!this.method_37908().method_8608() && !isStreamControlled) {
            this.mood = Mood.ANGRY;
            this.lastSpokeAge = this.field_6012;
        } else if (this.method_37908().method_8608() && (description = this.createDamageDescription(damageSource)) != null) {
            LeonEventHandler.getInstance().onExternalEvent(description);
        }
    }

    protected void method_6074(class_1282 source, float amount) {
        if (!this.method_5679(source)) {
            this.method_32876(class_5712.field_28736);
        }
    }

    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
    }

    public void method_5773() {
        super.method_5773();
        if (this == instance) {
            if (this.method_6032() < this.method_6063()) {
                this.method_6033(this.method_6063());
            }
            this.field_6278 = 0;
        }
    }

    protected boolean method_5776() {
        return this.field_6012 - this.lastSpokeAge < 120;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 0.25f;
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407((class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return this.field_6677.method_8320(pos.method_10074()).method_26215() && this.field_6677.method_8320(pos).method_26215();
            }
        };
        birdNavigation.method_6332(false);
        birdNavigation.method_6354(false);
        birdNavigation.method_6331(true);
        return birdNavigation;
    }

    public boolean method_5740() {
        return true;
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6185.method_6277(0, (class_1352)new ManageFocusedPlayerGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RemovePassengerGoal(this));
        this.field_6201.method_6277(0, (class_1352)new ExitVehicleGoal(this));
        this.field_6201.method_6277(0, (class_1352)new BreakLeashGoal(this));
        this.field_6201.method_6277(1, (class_1352)new StayWithFavoritePlayerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new AvoidCatGoal(this));
        this.field_6201.method_6277(3, (class_1352)new WanderNearFocusedGoal(this));
        this.field_6201.method_6277(3, (class_1352)new SayRandomVoiceLineGoal(this));
        this.field_6201.method_6277(4, (class_1352)new FollowPlayerGoal(this));
        this.field_6201.method_6277(5, (class_1352)new WanderAroundSpawnGoal(this));
    }

    public void method_5711(byte status) {
        switch (status) {
            case 10: {
                this.mood = Mood.NEUTRAL;
                break;
            }
            case 11: {
                this.mood = Mood.ANGRY;
                break;
            }
            case 12: {
                this.mood = Mood.UPSET;
                break;
            }
            case 13: {
                this.mood = Mood.HAPPY;
                break;
            }
            case 14: {
                this.mood = Mood.SAD;
                break;
            }
            case 15: {
                this.mood = Mood.LOVE;
                break;
            }
            case 16: {
                this.mood = Mood.HORNY;
                break;
            }
            case 17: {
                this.isStreamSpeaking = true;
                break;
            }
            case 18: {
                this.isStreamSpeaking = false;
                break;
            }
            case 19: {
                this.lastSpokeAge = this.field_6012;
                break;
            }
            default: {
                super.method_5711(status);
            }
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    public void method_6091(class_243 movementInput) {
        if (this.method_5787()) {
            if (this.method_5799()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)0.8f));
            } else if (this.method_5771()) {
                this.method_5724(0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.5));
            } else {
                float f = 0.91f;
                if (this.method_24828()) {
                    f = this.method_37908().method_8320(this.method_23314()).method_26204().method_9499() * 0.91f;
                }
                float g = 0.16277137f / (f * f * f);
                f = 0.91f;
                if (this.method_24828()) {
                    f = this.method_37908().method_8320(this.method_23314()).method_26204().method_9499() * 0.91f;
                }
                this.method_5724(this.method_24828() ? 0.1f * g : 0.02f, movementInput);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021((double)f));
            }
        }
        this.method_29242(false);
    }

    public boolean method_6101() {
        return false;
    }

    public void playAfraidSound() {
        this.playVoiceSound(SoundEventManager.LEON_VOICE_CAT_REACT_SOUND_EVENT);
    }

    public void playVoiceSound(class_3414 sound) {
        if (isStreamControlled) {
            return;
        }
        if (!(this.method_5701() || this.lastSpokeAge != -1 && this.field_6012 - this.lastSpokeAge <= 120)) {
            if (!this.method_37908().method_8608()) {
                this.method_37908().method_43129(null, (class_1297)this, sound, this.method_5634(), 1.0f, 1.0f);
                if (sound == SoundEventManager.LEON_VOICE_RANDOM_SOUND_EVENT) {
                    this.setMood(Mood.NEUTRAL);
                } else if (sound == SoundEventManager.LEON_VOICE_ANGRY_SOUND_EVENT || sound == SoundEventManager.LEON_VOICE_HURT_SOUND_EVENT) {
                    this.setMood(Mood.ANGRY);
                } else if (sound == SoundEventManager.LEON_VOICE_CAT_REACT_SOUND_EVENT) {
                    this.setMood(Mood.UPSET);
                } else if (sound == SoundEventManager.LEON_VOICE_JOKE_SOUND_EVENT) {
                    this.setMood(Mood.HAPPY);
                }
                this.method_37908().method_8421((class_1297)this, (byte)19);
            }
            if (sound == SoundEventManager.LEON_VOICE_RANDOM_SOUND_EVENT) {
                this.mood = Mood.NEUTRAL;
            } else if (sound == SoundEventManager.LEON_VOICE_ANGRY_SOUND_EVENT || sound == SoundEventManager.LEON_VOICE_HURT_SOUND_EVENT) {
                this.mood = Mood.ANGRY;
            } else if (sound == SoundEventManager.LEON_VOICE_CAT_REACT_SOUND_EVENT) {
                this.mood = Mood.UPSET;
            }
            this.lastSpokeAge = this.field_6012;
        }
    }

    public boolean isVoicePlaying() {
        if (this.isStreamSpeaking) {
            return true;
        }
        if (this.lastSpokeAge == -1) {
            return false;
        }
        return this.field_6012 - this.lastSpokeAge < 120;
    }

    private String createDamageDescription(class_1282 damageSource) {
        class_1297 attacker = damageSource.method_5529();
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            String playerName = player.method_5477().getString();
            String weapon = this.getWeaponDescription(player);
            if (weapon != null) {
                return class_2561.method_43469((String)"leonlerobot.event.player_attack_with_weapon", (Object[])new Object[]{playerName, weapon}).getString();
            }
            return class_2561.method_43469((String)"leonlerobot.event.player_attack_no_weapon", (Object[])new Object[]{playerName}).getString();
        }
        if (attacker instanceof class_1308) {
            class_1308 mob = (class_1308)attacker;
            return this.getMobAttackDescription(mob);
        }
        return null;
    }

    private String getWeaponDescription(class_1657 player) {
        class_1799 mainHandItem = player.method_6047();
        if (!mainHandItem.method_7960()) {
            return mainHandItem.method_7964().getString();
        }
        return null;
    }

    private String getMobAttackDescription(class_1308 mob) {
        String translatedMobName = mob.method_5477().getString();
        return class_2561.method_43469((String)"leonlerobot.event.mob_attack", (Object[])new Object[]{translatedMobName}).getString();
    }

    public static enum Mood {
        NEUTRAL,
        ANGRY,
        UPSET,
        HAPPY,
        SAD,
        LOVE,
        HORNY;

    }

    private record PlayerHitRecord(int tick, class_1657 player) {
    }
}

