/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.client.resourcepack;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class FrenchResourcePackManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrenchResourcePackManager.class);
    private static final String PACK_ID = "leonlerobot:french_pack";
    private static boolean isInitialized = false;

    public static void initialize() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("leonlerobot", "french_pack"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer("leonlerobot").orElseThrow()), (class_2561)class_2561.method_43470((String)"Voix fran\u00e7aise de L\u00e9on Le Robot"), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de l'enregistrement du resource pack fran\u00e7ais", (Throwable)e);
        }
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> FrenchResourcePackManager.checkAndActivateIfFrench());
    }

    private static void checkAndActivateIfFrench() {
        class_310 client = class_310.method_1551();
        if (client == null || client.method_1526() == null) {
            return;
        }
        String currentLanguage = client.method_1526().method_4669();
        if ("fr_fr".equals(currentLanguage)) {
            FrenchResourcePackManager.activateFrenchPack();
        }
    }

    private static void activateFrenchPack() {
        try {
            class_310 client = class_310.method_1551();
            if (client == null) {
                return;
            }
            class_3283 packManager = client.method_1520();
            class_3288 profile = packManager.method_14449(PACK_ID);
            if (profile != null) {
                ArrayList<String> enabledPacks = new ArrayList<String>(packManager.method_29210());
                if (!enabledPacks.contains(PACK_ID)) {
                    enabledPacks.add(PACK_ID);
                    packManager.method_14447(enabledPacks);
                    LOGGER.info("Pack fran\u00e7ais activ\u00e9 automatiquement (langue fran\u00e7aise d\u00e9tect\u00e9e)");
                }
            } else {
                LOGGER.warn("Profile du pack fran\u00e7ais non trouv\u00e9 : {}", (Object)PACK_ID);
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de l'activation du pack fran\u00e7ais", (Throwable)e);
        }
    }
}

