/*
 * Decompiled with CFR 0.152.
 */
package com.dremixam.leonlerobot.goals;

import com.dremixam.leonlerobot.LeonLeRobotEntity;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;

public abstract class FlyingGoalBase
extends class_1352 {
    protected final LeonLeRobotEntity leonEntity;
    protected final double minDistance = 1.0;
    private final class_1408 navigation;
    private int updateCountdownTicks;

    public FlyingGoalBase(LeonLeRobotEntity entity) {
        this.leonEntity = entity;
        this.navigation = entity.method_5942();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public void method_6269() {
        super.method_6269();
        this.updateCountdownTicks = 0;
    }

    public void method_6270() {
        super.method_6270();
        this.navigation.method_6340();
    }

    protected class_243 getTargetPosition() {
        class_1309 target = this.leonEntity.getFocused();
        return target != null ? target.method_19538() : null;
    }

    protected double travelSpeed(double distanceSqrd) {
        if (distanceSqrd >= 225.0) {
            return 10.0;
        }
        return 5.0;
    }

    public void method_6268() {
        if (this.leonEntity == null || this.leonEntity.method_37908() == null) {
            return;
        }
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = this.method_38847(10);
            class_243 target = this.getTargetPosition();
            if (target == null) {
                return;
            }
            this.leonEntity.method_5988().method_6230(target.method_10216(), target.method_10214(), target.method_10215(), (float)this.leonEntity.method_20240(), (float)this.leonEntity.method_5978());
            double distanceToTargetSqrd = this.leonEntity.method_19538().method_1025(target);
            if (distanceToTargetSqrd <= this.minDistance * this.minDistance) {
                this.navigation.method_6340();
            } else if (distanceToTargetSqrd >= 2304.0) {
                if (this.hasNearbyPlayers()) {
                    this.tryMoveAwayFromPlayers(target);
                } else {
                    this.tryTeleport();
                }
            } else if (distanceToTargetSqrd >= 225.0) {
                this.navigation.method_6337(target.method_10216(), target.method_10214(), target.method_10215(), this.travelSpeed(distanceToTargetSqrd));
            } else {
                this.navigation.method_6337(target.method_10216(), target.method_10214(), target.method_10215(), this.travelSpeed(distanceToTargetSqrd));
            }
        }
    }

    private boolean hasNearbyPlayers() {
        class_243 leonPos = this.leonEntity.method_19538();
        for (class_1657 player : this.leonEntity.method_37908().method_18456()) {
            double distanceToPlayer = leonPos.method_1022(player.method_19538());
            if (!(distanceToPlayer < 48.0)) continue;
            return true;
        }
        return false;
    }

    private void tryMoveAwayFromPlayers(class_243 target) {
        class_243 directionToTarget;
        class_243 leonPos = this.leonEntity.method_19538();
        class_243 baseEscapePosition = leonPos.method_1019((directionToTarget = target.method_1020(leonPos).method_1029()).method_1021(48.0));
        class_243 escapePosition = this.findAirBlock(baseEscapePosition);
        boolean navigationStarted = this.navigation.method_6337(escapePosition.method_10216(), escapePosition.method_10214(), escapePosition.method_10215(), 10.0);
        if (!navigationStarted || this.navigation.method_6357()) {
            this.tryTeleport();
        }
    }

    private class_243 findAirBlock(class_243 basePosition) {
        class_1937 world = this.leonEntity.method_37908();
        if (world == null) {
            return basePosition;
        }
        class_2338 currentPos = new class_2338((int)Math.floor(basePosition.method_10216()), (int)Math.floor(basePosition.method_10214()), (int)Math.floor(basePosition.method_10215()));
        for (int yOffset = 0; yOffset <= 20; ++yOffset) {
            class_2338 testPos = currentPos.method_10069(0, yOffset, 0);
            if (!world.method_8320(testPos).method_26215()) continue;
            return new class_243(basePosition.method_10216(), (double)testPos.method_10264(), basePosition.method_10215());
        }
        return new class_243(basePosition.method_10216(), basePosition.method_10214() + 20.0, basePosition.method_10215());
    }

    private void tryTeleport() {
        class_1309 target = this.leonEntity.getFocused();
        if (target == null) {
            return;
        }
        class_243 leonPos = this.leonEntity.method_19538();
        class_243 direction = target.method_19538().method_1020(leonPos).method_1029();
        double teleportDistance = 24.0;
        for (int step = 0; step < 20; ++step) {
            class_243 testPos = target.method_19538().method_1020(direction.method_1021(teleportDistance - (double)step));
            int x = (int)Math.floor(testPos.method_10216());
            int y = (int)Math.floor(testPos.method_10214());
            int z = (int)Math.floor(testPos.method_10215());
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                if (!this.tryTeleportTo(x, y + yOffset, z)) continue;
                this.leonEntity.method_18799(class_243.field_1353);
                return;
            }
        }
        class_2338 playerPos = target.method_24515();
        for (int i = 0; i < 5; ++i) {
            int z;
            int y;
            int xOffset = this.getRandomInt(-2, 2);
            int yOffset = this.getRandomInt(1, 3);
            int zOffset = this.getRandomInt(-2, 2);
            int x = playerPos.method_10263() + xOffset;
            if (!this.tryTeleportTo(x, y = playerPos.method_10264() + yOffset, z = playerPos.method_10260() + zOffset)) continue;
            this.leonEntity.method_18799(class_243.field_1353);
            return;
        }
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        class_1309 target = this.leonEntity.getFocused();
        if (target == null) {
            return false;
        }
        if (Math.abs((double)x - target.method_23317()) < 2.0 && Math.abs((double)z - target.method_23321()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z))) {
            return false;
        }
        this.leonEntity.method_5808((double)x + 0.5, y, (double)z + 0.5, this.leonEntity.method_36454(), this.leonEntity.method_36455());
        this.navigation.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos) {
        class_1937 world = this.leonEntity.method_37908();
        if (world == null) {
            return false;
        }
        class_2338 blockPos = pos.method_10059((class_2382)this.leonEntity.method_24515());
        class_1309 target = this.leonEntity.getFocused();
        if (target != null && (double)pos.method_10264() > target.method_23318() + 20.0) {
            return false;
        }
        return world.method_8587((class_1297)this.leonEntity, this.leonEntity.method_5829().method_996(blockPos));
    }

    private int getRandomInt(int min, int max) {
        return this.leonEntity.method_6051().method_43048(max - min + 1) + min;
    }
}

